#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleUnnecessaryImport_h
#include "RuleUnnecessaryImport.h"
#endif

#ifndef ErrorUnnecessaryImport_h
#include "ErrorUnnecessaryImport.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleUnnecessaryImport";

class RuleUnnecessaryImportTest : 
    public RuleTest<ruleName, RuleUnnecessaryImport, ErrorUnnecessaryImport>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec;
            vec.push_back("import java.lang.Object;");
            vec.push_back("");
            vec.push_back("class RuleUnnecessaryImport {");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("import java.lang.*;");
            vec.push_back("");
            vec.push_back("class RuleUnnecessaryImport {");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("import java.lang.ref.*;");
            vec.push_back("");
            vec.push_back("class RuleUnnecessaryImport {");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("import java.lang.reflect.Array;");
            vec.push_back("");
            vec.push_back("class RuleUnnecessaryImport {");
            vec.push_back("}");
            contents->push_back(vec);
        }
    }

    virtual int errorsExpected(int num) const { 
        return num < 2 ? 1 : 0; 
    }

};

int main(int argc, char** argv) 
{
    RuleUnnecessaryImportTest t;
    t.run();
    cout << "unnecessary import rule test results: " << t << endl;
    return t.nerrors();
}
