#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleUninitializedStaticField_h
#include "RuleUninitializedStaticField.h"
#endif

#ifndef ErrorUninitializedStaticField_h
#include "ErrorUninitializedStaticField.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleUninitializedStaticField";

class RuleUninitializedStaticFieldTest : 
    public RuleTest<ruleName, RuleUninitializedStaticField, ErrorUninitializedStaticField>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleUninitializedStaticField {");
            vec.push_back("    static int f;");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleUninitializedStaticField {");
            vec.push_back("    static public int f;");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleUninitializedStaticField {");
            vec.push_back("    public int f;");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleUninitializedStaticField {");
            vec.push_back("    static int f = 0;");
            vec.push_back("}");
            contents->push_back(vec);
        }
    }

    virtual int errorsExpected(int num) const { 
        return num < 2 ? 1 : 0; 
    }

};

int main(int argc, char** argv) 
{
    RuleUninitializedStaticFieldTest t;
    t.run();
    cout << "uninitialized static field rule test results: " << t << endl;
    return t.nerrors();
}
