#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleRepeatedImportStatement_h
#include "RuleRepeatedImportStatement.h"
#endif

#ifndef ErrorRepeatedImportStatement_h
#include "ErrorRepeatedImportStatement.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleRepeatedImportStatement";

class RuleRepeatedImportStatementTest : 
    public RuleTest<ruleName, RuleRepeatedImportStatement, ErrorRepeatedImportStatement>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec;
            vec.push_back("import java.util.Vector;");
            vec.push_back("import java.util.Map;");
            vec.push_back("import java.util.Vector;");
            vec.push_back("");
            vec.push_back("class RuleRepeatedImportStatement {");
            vec.push_back("    RuleRepeatedImportStatement() {");
            vec.push_back("        while (false);"); 
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("import java.util.*;");
            vec.push_back("import java.io.*;");
            vec.push_back("import java.io.*;");
            vec.push_back("");
            vec.push_back("class RuleRepeatedImportStatement {");
            vec.push_back("    RuleRepeatedImportStatement() {");
            vec.push_back("        while (false);"); 
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("import java.util.*;");
            vec.push_back("import java.io.*;");
            vec.push_back("import java.io.*;");
            vec.push_back("import java.io.IOException;");
            vec.push_back("import java.util.*;");
            vec.push_back("");
            vec.push_back("class RuleRepeatedImportStatement {");
            vec.push_back("    RuleRepeatedImportStatement() {");
            vec.push_back("        while (false);"); 
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("import java.util.*;");
            vec.push_back("import java.io.*;");
            vec.push_back("import java.io.IOException;");
            vec.push_back("import java.util.Vector;");
            vec.push_back("");
            vec.push_back("class RuleRepeatedImportStatement {");
            vec.push_back("    RuleRepeatedImportStatement() {");
            vec.push_back("        while (false) {"); 
            vec.push_back("            // nothing"); 
            vec.push_back("        }");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }

        {
            std::vector<std::string> vec;
            vec.push_back("import java.util.Vector;");
            vec.push_back("import java.util.Map;");
            vec.push_back("import org.incava.util.Vector;");
            vec.push_back("");
            vec.push_back("class RuleRepeatedImportStatement {");
            vec.push_back("    RuleRepeatedImportStatement() {");
            vec.push_back("        while (false);"); 
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
    }

    virtual int errorsExpected(int num) const
    { 
        switch (num) {
            case 0:  return 1;  break;
            case 1:  return 1;  break;
            case 2:  return 2;  break;
            case 3:  return 0;  break;
            case 4:  return 0;  break;
            default: return -1; break;
        }
    }

};

int main(int argc, char** argv) 
{
    RuleRepeatedImportStatementTest t;
    t.run();
    cout << "repeated import statement rule test results: " << t << endl;
    return t.nerrors();
}
