#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleObjectSubclassesCompared_h
#include "RuleObjectSubclassesCompared.h"
#endif

#ifndef ErrorObjectSubclassesCompared_h
#include "ErrorObjectSubclassesCompared.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleObjectSubclassesCompared";

class RuleObjectSubclassesComparedTest : 
    public RuleTest<ruleName, RuleObjectSubclassesCompared, ErrorObjectSubclassesCompared>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleObjectSubclassesCompared {");
            vec.push_back("    void foo() {");
            vec.push_back("        String h = \"hello\";"); 
            vec.push_back("        String w = \"world\";"); 
            vec.push_back("        if (h == w) {"); 
            vec.push_back("        }");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleObjectSubclassesCompared {");
            vec.push_back("    void foo(Integer i, Integer j) {");
            vec.push_back("        if (i == j) {"); 
            vec.push_back("        }");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }

        {
            std::vector<std::string> vec;
            vec.push_back("class RuleObjectSubclassesCompared {");
            vec.push_back("    Double df;");
            vec.push_back("    void foo() {");
            vec.push_back("        if (df == dFromSuperClass) {"); 
            vec.push_back("        }");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleObjectSubclassesCompared {");
            vec.push_back("    Double df;");
            vec.push_back("    void foo() {");
            vec.push_back("        if (method() == df) {"); 
            vec.push_back("        }");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleObjectSubclassesCompared {");
            vec.push_back("    void foo() {");
            vec.push_back("        int h = 5;"); 
            vec.push_back("        int w = 5;"); 
            vec.push_back("        if (h == w) {"); 
            vec.push_back("        }");
            vec.push_back("    }");

            vec.push_back("    RuleObjectSubclassesCompared() {");
            vec.push_back("        while (false) {"); 
            vec.push_back("            // nothing"); 
            vec.push_back("        }");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
    }

    virtual int errorsExpected(int num) const { 
        return num < 4 ? 1 : 0; 
    }

};

int main(int argc, char** argv) 
{
    RuleObjectSubclassesComparedTest t;
    t.run();
    cout << "object subclasses compared rule test results: " << t << endl;
    return t.nerrors();
}
