#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleNoDefaultCase_h
#include "RuleNoDefaultCase.h"
#endif

#ifndef ErrorNoDefaultCase_h
#include "ErrorNoDefaultCase.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleNoDefaultCase";

class RuleNoDefaultCaseTest : 
    public RuleTest<ruleName, RuleNoDefaultCase, ErrorNoDefaultCase>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleNoDefaultCase {");
            vec.push_back("    RuleNoDefaultCase(int i) {");
            vec.push_back("        switch (i) {"); 
            vec.push_back("            case 0:"); 
            vec.push_back("                break;"); 
            vec.push_back("            case 1:");
            vec.push_back("                break;"); 
            vec.push_back("        }");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }

        {
            std::vector<std::string> vec;
            vec.push_back("class RuleNoDefaultCase {");
            vec.push_back("    RuleNoDefaultCase(int i) {");
            vec.push_back("        switch (i) {"); 
            vec.push_back("        }");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }

        {
            std::vector<std::string> vec;
            vec.push_back("class RuleNoDefaultCase {");
            vec.push_back("    RuleNoDefaultCase(int i) {");
            vec.push_back("        switch (i) {"); 
            vec.push_back("            case 0:"); 
            vec.push_back("                break;"); 
            vec.push_back("            case 1:");
            vec.push_back("                break;"); 
            vec.push_back("            default:");
            vec.push_back("        }");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }

    }

    virtual int errorsExpected(int num) const { 
        return num < 2 ? 1 : 0; 
    }

};

int main(int argc, char** argv) 
{
    RuleNoDefaultCaseTest t;
    t.run();
    cout << "no default case rule test results: " << t << endl;
    return t.nerrors();
}
