#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleNoBreakInCaseStatement_h
#include "RuleNoBreakInCaseStatement.h"
#endif

#ifndef ErrorNoBreakInCaseStatement_h
#include "ErrorNoBreakInCaseStatement.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleNoBreakInCaseStatement";

class RuleNoBreakInCaseStatementTest : 
    public RuleTest<ruleName, RuleNoBreakInCaseStatement, ErrorNoBreakInCaseStatement>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleNoBreakInCaseStatement {");
            vec.push_back("    RuleNoBreakInCaseStatement(int i) {");
            vec.push_back("        switch (i) {"); 
            vec.push_back("            case 0:"); 
            vec.push_back("                System.out.println(\"i == 0\");"); 
            vec.push_back("            case 1:");
            vec.push_back("                System.out.println(\"i == 1\");"); 
            vec.push_back("                break;"); 
            vec.push_back("        }");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleNoBreakInCaseStatement {");
            vec.push_back("    RuleNoBreakInCaseStatement(int i) {");
            vec.push_back("        switch (i) {"); 
            vec.push_back("            case 0:"); 
            vec.push_back("                System.out.println(\"i == 0\");"); 
            vec.push_back("                // fallthrough"); 
            vec.push_back("            case 1:");
            vec.push_back("                System.out.println(\"i == 1\");"); 
            vec.push_back("                break;"); 
            vec.push_back("        }");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleNoBreakInCaseStatement {");
            vec.push_back("    RuleNoBreakInCaseStatement(int i) {");
            vec.push_back("        switch (i) {"); 
            vec.push_back("            case 0:"); 
            vec.push_back("                System.exit(1);"); 
            vec.push_back("            case 1:");
            vec.push_back("                System.out.println(\"i == 1\");"); 
            vec.push_back("                break;"); 
            vec.push_back("        }");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleNoBreakInCaseStatement {");
            vec.push_back("    RuleNoBreakInCaseStatement(int i) {");
            vec.push_back("        switch (i) {"); 
            vec.push_back("            case 0:"); 
            vec.push_back("                return;"); 
            vec.push_back("            case 1:");
            vec.push_back("                System.out.println(\"i == 1\");"); 
            vec.push_back("                break;"); 
            vec.push_back("        }");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
    }

    virtual int errorsExpected(int num) const { 
        return num < 1 ? 1 : 0; 
    }

};

int main(int argc, char** argv) 
{
    RuleNoBreakInCaseStatementTest t;
    t.run();
    cout << "no break in case statement rule test results: " << t << endl;
    return t.nerrors();
}
