#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleImproperSequence_h
#include "RuleImproperSequence.h"
#endif

#ifndef ErrorImproperSequence_h
#include "ErrorImproperSequence.h"
#endif

#ifndef UserPreferences_h
#include "UserPreferences.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleImproperSequence";

class RuleImproperSequenceTest : 
    public RuleTest<ruleName, RuleImproperSequence, ErrorImproperSequence>
{
public:
    RuleImproperSequenceTest() {
        UserPreferences* prefs = UserPreferences::get();

        // in real life, these are read by the app at startup.

        prefs->typeOrder.push_back("public.static.final.field");
        prefs->typeOrder.push_back("package.static.final.field");
        prefs->typeOrder.push_back("protected.static.final.field");
        prefs->typeOrder.push_back("private.static.final.field");

        prefs->typeOrder.push_back("public.static.final.class");
        prefs->typeOrder.push_back("public.static.nonfinal.class");
        prefs->typeOrder.push_back("package.static.final.class");
        prefs->typeOrder.push_back("package.static.nonfinal.class");
        prefs->typeOrder.push_back("protected.static.final.class");
        prefs->typeOrder.push_back("protected.static.nonfinal.class");
        prefs->typeOrder.push_back("private.static.final.class");
        prefs->typeOrder.push_back("private.static.nonfinal.class");

        prefs->typeOrder.push_back("public.instance.final.class");
        prefs->typeOrder.push_back("public.instance.nonfinal.class");
        prefs->typeOrder.push_back("package.instance.final.class");
        prefs->typeOrder.push_back("package.instance.nonfinal.class");
        prefs->typeOrder.push_back("protected.instance.final.class");
        prefs->typeOrder.push_back("protected.instance.nonfinal.class");
        prefs->typeOrder.push_back("private.instance.final.class");
        prefs->typeOrder.push_back("private.instance.nonfinal.class");

        prefs->typeOrder.push_back("public.static.final.interface");
        prefs->typeOrder.push_back("public.static.nonfinal.interface");
        prefs->typeOrder.push_back("package.static.final.interface");
        prefs->typeOrder.push_back("package.static.nonfinal.interface");
        prefs->typeOrder.push_back("protected.static.final.interface");
        prefs->typeOrder.push_back("protected.static.nonfinal.interface");
        prefs->typeOrder.push_back("private.static.final.interface");
        prefs->typeOrder.push_back("private.static.nonfinal.interface");

        prefs->typeOrder.push_back("public.instance.final.interface");
        prefs->typeOrder.push_back("public.instance.nonfinal.interface");
        prefs->typeOrder.push_back("package.instance.final.interface");
        prefs->typeOrder.push_back("package.instance.nonfinal.interface");
        prefs->typeOrder.push_back("protected.instance.final.interface");
        prefs->typeOrder.push_back("protected.instance.nonfinal.interface");
        prefs->typeOrder.push_back("private.instance.final.interface");
        prefs->typeOrder.push_back("private.instance.nonfinal.interface");

        prefs->typeOrder.push_back("public.static.nonfinal.field");
        prefs->typeOrder.push_back("package.static.nonfinal.field");
        prefs->typeOrder.push_back("protected.static.nonfinal.field");
        prefs->typeOrder.push_back("private.static.nonfinal.field");

        prefs->typeOrder.push_back("public.instance.final.field");
        prefs->typeOrder.push_back("package.instance.final.field");
        prefs->typeOrder.push_back("protected.instance.final.field");
        prefs->typeOrder.push_back("private.instance.final.field");

        prefs->typeOrder.push_back("public.instance.nonfinal.field");
        prefs->typeOrder.push_back("package.instance.nonfinal.field");
        prefs->typeOrder.push_back("protected.instance.nonfinal.field");
        prefs->typeOrder.push_back("private.instance.nonfinal.field");

        prefs->typeOrder.push_back("public.static.final.method");
        prefs->typeOrder.push_back("public.static.nonfinal.method");
        prefs->typeOrder.push_back("package.static.final.method");
        prefs->typeOrder.push_back("package.static.nonfinal.method");
        prefs->typeOrder.push_back("protected.static.final.method");
        prefs->typeOrder.push_back("protected.static.nonfinal.method");
        prefs->typeOrder.push_back("private.static.final.method");
        prefs->typeOrder.push_back("private.static.nonfinal.method");

        prefs->typeOrder.push_back("public.ctor");
        prefs->typeOrder.push_back("package.ctor");
        prefs->typeOrder.push_back("protected.ctor");
        prefs->typeOrder.push_back("private.ctor");

        prefs->typeOrder.push_back("public.method.finalize");
        prefs->typeOrder.push_back("package.method.finalize");
        prefs->typeOrder.push_back("protected.method.finalize");
        prefs->typeOrder.push_back("private.method.finalize");

        prefs->typeOrder.push_back("public.instance.final.method");
        prefs->typeOrder.push_back("public.instance.nonfinal.method");
        prefs->typeOrder.push_back("package.instance.final.method");
        prefs->typeOrder.push_back("package.instance.nonfinal.method");
        prefs->typeOrder.push_back("protected.instance.final.method");
        prefs->typeOrder.push_back("protected.instance.nonfinal.method");
        prefs->typeOrder.push_back("private.instance.final.method");
        prefs->typeOrder.push_back("private.instance.nonfinal.method");

        prefs->typeOrder.push_back("public.instance.nonfinal.abstractmethod");
        prefs->typeOrder.push_back("package.instance.nonfinal.abstractmethod");
        prefs->typeOrder.push_back("protected.instance.nonfinal.abstractmethod");
        prefs->typeOrder.push_back("private.instance.nonfinal.abstractmethod");

        prefs->typeOrder.push_back("public.instance.final.method");
        prefs->typeOrder.push_back("package.instance.final.method");
        prefs->typeOrder.push_back("protected.instance.final.method");
        prefs->typeOrder.push_back("private.instance.final.method");

        prefs->typeOrder.push_back("public.static.*.method.main");
    }

    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleImproperSequence {");
            vec.push_back("");
            vec.push_back("    public static void main() {");
            vec.push_back("    }");
            vec.push_back("");
            vec.push_back("    public RuleImproperSequence() {");
            vec.push_back("    }");
            vec.push_back("");
            vec.push_back("    private int _errorHandler;");
            vec.push_back("");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleImproperSequence {");
            vec.push_back("");
            vec.push_back("    public RuleImproperSequence() {");
            vec.push_back("    }");
            vec.push_back("");
            vec.push_back("    public static void main() {");
            vec.push_back("    }");
            vec.push_back("");
            vec.push_back("    private int _errorHandler;");
            vec.push_back("");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleImproperSequence {");
            vec.push_back("");
            vec.push_back("    public static void main(String[] args) {");
            vec.push_back("    }");
            vec.push_back("");
            vec.push_back("    public RuleImproperSequence() {");
            vec.push_back("    }");
            vec.push_back("");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("interface RuleImproperSequence {");
            vec.push_back("");
            vec.push_back("    private void priv();");
            vec.push_back("");
            vec.push_back("    public void pub();");
            vec.push_back("");
            vec.push_back("    protected void prot();");
            vec.push_back("");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("interface RuleImproperSequence {");
            vec.push_back("");
            vec.push_back("    private void priv();");
            vec.push_back("");
            vec.push_back("    protected void prot();");
            vec.push_back("");
            vec.push_back("    public void pub();");
            vec.push_back("");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("interface RuleImproperSequence {");
            vec.push_back("");
            vec.push_back("    private void priv();");
            vec.push_back("");
            vec.push_back("    protected void prot();");
            vec.push_back("");
            vec.push_back("    public void pub();");
            vec.push_back("");
            vec.push_back("    void pkg();");
            vec.push_back("");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
    }

    virtual int errorsExpected(int num) const { 
        switch (num) {
            case 0:
                return 2;
                break;

            case 1:
                return 1;
                break;

            case 2:
                return 1;
                break;

            case 3:
                return 1;
                break;

            case 4:
                return 2;
                break;

            case 5:
                return 2;
                break;

            default:
                return 0;
        }
    }

};

int main(int argc, char** argv) 
{
    RuleImproperSequenceTest t;
    t.run();
    cout << "improper sequence rule test results: " << t << endl;
    return t.nerrors();
}
