#ifndef RuleUselessThisInMethodInvocation_h
#include "RuleUselessThisInMethodInvocation.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorUselessThisInMethodInvocation_h
#include "ErrorUselessThisInMethodInvocation.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

RuleUselessThisInMethodInvocation::RuleUselessThisInMethodInvocation(Reporter* const reporter) : Rule(reporter)
{
}

RuleUselessThisInMethodInvocation::~RuleUselessThisInMethodInvocation()
{
}

void RuleUselessThisInMethodInvocation::process(AstMethodInvocationPrimary* const mi)
{
    SYNLOG("");

    AstItem* primary = mi->getPrimary();
    if (AstThis* tthis = dynamic_cast<AstThis*>(primary)) {
        string method = mi->text();
        ErrorUselessThisInMethodInvocation* err = new ErrorUselessThisInMethodInvocation(reporter(), mi);
        err->process();
    }

    traverse(mi);
}

void RuleUselessThisInMethodInvocation::process(AstMethodInvocationPrimaryArgs* const mi)
{
    process((AstMethodInvocationPrimary*)mi);
}

void RuleUselessThisInMethodInvocation::process(AstMethodInvocationPrimaryNoArgs* const mi)
{
    process((AstMethodInvocationPrimary*)mi);
}

