#ifndef RuleUninitializedStaticField_h
#include "RuleUninitializedStaticField.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef ErrorUninitializedStaticField_h
#include "ErrorUninitializedStaticField.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

RuleUninitializedStaticField::RuleUninitializedStaticField(Reporter* const reporter) : Rule(reporter)
{
}

RuleUninitializedStaticField::~RuleUninitializedStaticField()
{
}

void RuleUninitializedStaticField::process(AstFieldDeclarationMods* const fd)
{
    SYNLOG("");

    JavaModifierList mods(fd);

    // warn about noninitialized static fields
    if (mods.containsStatic()) {
        AstVariableDeclaratorList* vdl  = fd->getVariableDeclaratorList();
        int count = vdl->getVariableDeclaratorCount();
        for (int i = 0; i < count; ++i) {
            AstVariableDeclarator* vd = vdl->getVariableDeclarator(i);
            if (!dynamic_cast<AstVariableDeclaratorAssign*>(vd)) {
                ErrorUninitializedStaticField* err = new ErrorUninitializedStaticField(reporter(), vd);
                err->process();
            }
        }       
    }
}
