#ifndef RuleReturnFromVoidMethod_h
#include "RuleReturnFromVoidMethod.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorReturnFromVoidMethod_h
#include "ErrorReturnFromVoidMethod.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

RuleReturnFromVoidMethod::RuleReturnFromVoidMethod(Reporter* const reporter) : Rule(reporter)
{
}

RuleReturnFromVoidMethod::~RuleReturnFromVoidMethod()
{
}

void RuleReturnFromVoidMethod::process(AstReturnStatementEmpty* const rs)
{
    SYNLOG("");

    AstMethodDeclaration* md = NULL;
    AstItem* it = rs->parent();
    while (it && !md) {
        md = dynamic_cast<AstMethodDeclaration*>(it);
        it = it->parent();
    }

    if (md) {
        JavaMethod method(md);
        ErrorReturnFromVoidMethod* err = new ErrorReturnFromVoidMethod(reporter(), rs, method.getName());
        err->process();
    }
}
