#ifndef RuleRepeatedImportStatement_h
#include "RuleRepeatedImportStatement.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorRepeatedImportStatement_h
#include "ErrorRepeatedImportStatement.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

RuleRepeatedImportStatement::RuleRepeatedImportStatement(Reporter* const reporter) : Rule(reporter)
{
}

RuleRepeatedImportStatement::~RuleRepeatedImportStatement()
{
}

void RuleRepeatedImportStatement::process(AstCompilationUnit* const cu)
{
    imports_.clear();

    traverse(cu);
}

void RuleRepeatedImportStatement::process(AstCompilationUnitEmpty* const cu)
{
    process((AstCompilationUnit*)cu);
}

void RuleRepeatedImportStatement::process(AstCompilationUnitImp* const cu)
{
    process((AstCompilationUnit*)cu);
}

void RuleRepeatedImportStatement::process(AstCompilationUnitImpTypes* const cu)
{
    process((AstCompilationUnit*)cu);
}

void RuleRepeatedImportStatement::process(AstCompilationUnitPkg* const cu)
{
    process((AstCompilationUnit*)cu);
}

void RuleRepeatedImportStatement::process(AstCompilationUnitPkgImp* const cu)
{
    process((AstCompilationUnit*)cu);
}

void RuleRepeatedImportStatement::process(AstCompilationUnitPkgImpTypes* const cu)
{
    process((AstCompilationUnit*)cu);
}

void RuleRepeatedImportStatement::process(AstCompilationUnitPkgTypes* const cu)
{
    process((AstCompilationUnit*)cu);
}

void RuleRepeatedImportStatement::process(AstCompilationUnitTypes* const cu)
{
    process((AstCompilationUnit*)cu);
}

void RuleRepeatedImportStatement::process(AstImportDeclaration* const id)
{
    SYNLOG("");

    // check for repeats
    string            name   = id->importee();
    ReferencedImport* import = imports_.findByFullName(name);

    SYNLOG(string("got import ") + (import ? import->fullName() : string("NULL")));
    
    if (import) {
        ErrorRepeatedImportStatement* err = new ErrorRepeatedImportStatement(reporter(), id);
        err->process();
    }
}

void RuleRepeatedImportStatement::process(AstImportDeclarationOnDemand* const id)
{
    process((AstImportDeclaration*)id);
    imports_.add(id);
}

void RuleRepeatedImportStatement::process(AstImportDeclarationSingle* const id)
{
    process((AstImportDeclaration*)id);
    imports_.add(id);
}
