#ifndef RuleModifiersOutOfOrder_h
#include "RuleModifiersOutOfOrder.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorModifiersOutOfOrder_h
#include "ErrorModifiersOutOfOrder.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

/**
 * Returns the preferred order (IAW JPL3:38):
 *
 *     access
 *     static
 *     final
 *     transient
 *     volatile
 */
static int getModifierPreferredIndex(AstItem* const it)
{
    if (dynamic_cast<AstPublic*>(it)    ||
        dynamic_cast<AstProtected*>(it) ||
        dynamic_cast<AstPrivate*>(it)) {
        return 0;
    }
    else if (dynamic_cast<AstStatic*>(it)) {
        return 1;
    }
    else if (dynamic_cast<AstFinal*>(it)) {
        return 2;
    }
    else if (dynamic_cast<AstTransient*>(it)) {
        return 3;
    }
    else if (dynamic_cast<AstVolatile*>(it)) {
        return 4;
    }
    else {
        cerr << "ERROR: getModifierPreferredIndex: unexpected modifier: " << it->text() << endl;
        return -1;
    }
}

RuleModifiersOutOfOrder::RuleModifiersOutOfOrder(Reporter* const reporter) : Rule(reporter)
{
}

RuleModifiersOutOfOrder::~RuleModifiersOutOfOrder()
{
}

void RuleModifiersOutOfOrder::process(AstModifierList* const mods)
{
    SYNLOG("");

    int      count     = mods->getModifierCount();
    int      lastIndex = -1;
    AstItem* previous  = NULL;
    
    for (int i = 0; i < count; ++i) {
        AstItem* current = mods->getModifier(i);
        int      index   = getModifierPreferredIndex(current);
        if (lastIndex > index) {
            ErrorModifiersOutOfOrder* err = new ErrorModifiersOutOfOrder(reporter(), mods, current, previous);
            err->process();
        }
        lastIndex = index;
        previous = current;
    }


    traverse(mods);
}

