#ifndef RuleExplicitFalseInConditional_h
#include "RuleExplicitFalseInConditional.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef ErrorExplicitFalseInConditional_h
#include "ErrorExplicitFalseInConditional.h"
#endif

using namespace std;
using namespace doctorj;

RuleExplicitFalseInConditional::RuleExplicitFalseInConditional(Reporter* const reporter) : Rule(reporter)
{
}

RuleExplicitFalseInConditional::~RuleExplicitFalseInConditional()
{
}

void RuleExplicitFalseInConditional::process(AstEqualityExpressionEq* const ee)
{
    process((AstEqualityExpression*)ee);
}

void RuleExplicitFalseInConditional::process(AstEqualityExpressionNe* const ee)
{
    process((AstEqualityExpression*)ee);
}

void RuleExplicitFalseInConditional::process(AstEqualityExpression* const ee)
{
    if (JavaEqualityExpression::hasFalseLiteralInExpression(ee)) {
        (new ErrorExplicitFalseInConditional(reporter(), ee))->process();
    }
    traverse(ee);
}
