#ifndef RuleEmptyIfStatement_h
#include "RuleEmptyIfStatement.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef ErrorEmptyIfStatement_h
#include "ErrorEmptyIfStatement.h"
#endif

using namespace std;
using namespace doctorj;

RuleEmptyIfStatement::RuleEmptyIfStatement(Reporter* const reporter) : Rule(reporter)
{
}

RuleEmptyIfStatement::~RuleEmptyIfStatement()
{
}

void RuleEmptyIfStatement::process(AstIfThenElseStatement* const it)
{
    if (JavaItem::isEmptyStatement(it->getFirstStatement()) || 
        JavaItem::isEmptyStatement(it->getSecondStatement())) {
        (new ErrorEmptyIfStatement(reporter(), it))->process();
    }
    traverse(it);
}

void RuleEmptyIfStatement::process(AstIfThenStatement* const it)
{
    if (JavaItem::isEmptyStatement(it->getStatement())) {
        (new ErrorEmptyIfStatement(reporter(), it))->process();
    }
    traverse(it);
}
