#ifndef ReferencedImport_h
#define ReferencedImport_h

#ifndef std_string
#define std_string
#include <string>
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

using namespace std;

namespace doctorj
{
    class AstImportDeclaration;

    class ReferencedImport 
    {
    public:
        ReferencedImport(AstImportDeclaration* const id);

        virtual ~ReferencedImport();

        int numReferences() const;

        void addReference();

        /**
         * Returns whether the type name is an exact match for this import.
         * Single imports can be exact matches; on-demand imports cannot. This
         * method can resolve ambiguity.
         */
        virtual bool isExactMatch(const string& typeName) const = 0;

        /**
         * Returns whether the type name is (as least) an approximate match for
         * this import.
         */
        virtual bool isMatch(const string& typeName) const = 0;
        
        string fullName() const;
    
        AstImportDeclaration* declaration() const;

        /**
         * Returns whether this was unused (unreferenced).
         */
        virtual bool isUnused() const;
        
    private:
        AstImportDeclaration* id_;

        string fullName_;

        int nReferences_;
    };


    class AstImportDeclarationSingle;

    class ReferencedSingleImport : public ReferencedImport
    {
    public:
        ReferencedSingleImport(AstImportDeclarationSingle* const id);

        virtual ~ReferencedSingleImport();

        string alias() const;

        /**
         * Returns whether the type name is an exact match for this import.
         * Single imports can be exact matches; on-demand imports cannot. This
         * method can resolve ambiguity.
         */
        bool isExactMatch(const string& typeName) const;

        /**
         * Returns whether the type name is (as least) an approximate match for
         * this import.
         */
        bool isMatch(const string& typeName) const;
    
    private:
        string alias_;
    };


    class AstImportDeclarationOnDemand;

    class ReferencedOnDemandImport : public ReferencedImport
    {
    public:
        ReferencedOnDemandImport(AstImportDeclarationOnDemand* const id);

        virtual ~ReferencedOnDemandImport();

        string package() const;

        /**
         * Returns whether the type name is an exact match for this import.
         * On-demand imports cannot be an exact match for any type name.
         */
        bool isExactMatch(const string& typeName) const;

        /**
         * Returns whether the type name is (as least) an approximate match for
         * this import.
         */
        bool isMatch(const string& typeName) const;

        /**
         * Returns whether this was unused (unreferenced).
         */
        bool isUnused() const;

    private:
        
        /**
         * The name of the package.
         */
        string package_;

        /**
         * The classes that match this package name. Loaded on demand (no pun
         * intended).
         */
        mutable vector<string>* classes_; // lazy evaluation from const method

        /**
         * Whether this import should/could be checked, that is, we could find
         * an import for it.
         */
        mutable bool checkable_;

    };

}

#endif //! ReferencedImport_h
