#ifndef MethodHeaderSyntaxAnalyzer_h
#define MethodHeaderSyntaxAnalyzer_h

#ifndef Analyzer_h
#include "Analyzer.h"
#endif

namespace doctorj 
{
    class Reporter;
    class AstMethodHeader;
    class AstItem;
    class AstModifierList;
    class AstThrowsNameList;

    class MethodHeaderSyntaxAnalyzer : public Analyzer 
    {
    public:

        MethodHeaderSyntaxAnalyzer(Reporter* const reporter,
                                   AstMethodHeader* const header, 
                                   AstItem* const returnType,
                                   AstModifierList* const modifiers,
                                   AstThrowsNameList* const throwsList);

        virtual ~MethodHeaderSyntaxAnalyzer();

        virtual void check();

        /**
         * The category of this analyzer, as a single character.
         */
        virtual char category() const;

    private:

        AstMethodHeader* header_;

        AstItem* returnType_;

        AstModifierList* modifiers_;

        AstThrowsNameList* throwsList_;

    };
}

#endif //! MethodHeaderSyntaxAnalyzer_h
