#ifndef FieldReferenceList_h
#define FieldReferenceList_h

#ifndef std_string
#define std_string
#include <string>
#endif

#ifndef std_map
#define std_map
#include <map>
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

using namespace std;

namespace doctorj
{
    class AstFieldDeclaration;
    
    class FieldReferenceList 
    {
    public:
        FieldReferenceList();

        virtual ~FieldReferenceList();

        /**
         * Adds the field declaration to the list.
         */
        void addDeclaration(AstFieldDeclaration* const fd);

        /**
         * Adds a reference for the given field name, if it can be found as a
         * declaration. Returns whether it could be added (found).
         */
        bool addReference(const string& fieldName);

        /**
         * Clears the list.
         */
        void clear();

        /**
         * Returns a list of unreferenced fields.
         */
        vector<AstFieldDeclaration*> getUnreferencedFields() const;

    private:
        map<AstFieldDeclaration*, int> references_;

    };
    
}

#endif //! FieldReferenceList_h
