#ifndef ErrorUnreferencedImport_h
#define ErrorUnreferencedImport_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class AstImportDeclaration;

    class ErrorUnreferencedImport : public SyntaxError 
    {
    public:
        
        ErrorUnreferencedImport();

        /**
         * Creates the error.
         */
        ErrorUnreferencedImport(Reporter* const reporter, AstImportDeclaration* const id);
        
        virtual ~ErrorUnreferencedImport();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    private:

    };

}

#endif //! ErrorUnreferencedImport_h
