#ifndef ErrorUnnecessaryImport_h
#include "ErrorUnnecessaryImport.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif


using namespace doctorj;

REGISTER_DESCRIPTION(ErrorUnnecessaryImport);

ErrorUnnecessaryImport::ErrorUnnecessaryImport()
{
}

ErrorUnnecessaryImport::ErrorUnnecessaryImport(Reporter* const reporter, AstImportDeclaration* const id) :
        SyntaxError(reporter, id)
{
}

ErrorUnnecessaryImport::~ErrorUnnecessaryImport()
{
}

string ErrorUnnecessaryImport::title() const
{
    return "Unnecessary Import";
}

void ErrorUnnecessaryImport::writeDescription(ostream& os) const
{
    os << "The import declaration is not necessary; java.lang.* is implicitly imported." << endl;
}

string ErrorUnnecessaryImport::message() const
{
    return "the import declaration is not necessary";
}
