#ifndef ErrorUninitializedStaticField_h
#define ErrorUninitializedStaticField_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj
{
    class AstVariableDeclarator;
    
    class ErrorUninitializedStaticField : public SyntaxError
    {
    public:
        
        ErrorUninitializedStaticField();

        ErrorUninitializedStaticField(Reporter* const reporter, AstVariableDeclarator* const vd);

        virtual ~ErrorUninitializedStaticField();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    private:
        /**
         * The name of the field.
         */
        string name_;

    };

}

#endif //! ErrorUninitializedStaticField_h
