#ifndef ErrorRepeatedImportStatement_h
#define ErrorRepeatedImportStatement_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class AstImportDeclaration;

    class ErrorRepeatedImportStatement : public SyntaxError 
    {
    public:
        
        ErrorRepeatedImportStatement();

        /**
         * Creates the error.
         */
        ErrorRepeatedImportStatement(Reporter* const reporter, AstImportDeclaration* const id);
        
        virtual ~ErrorRepeatedImportStatement();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    private:

    };

}

#endif //! ErrorRepeatedImportStatement_h
