#ifndef ErrorPublicField_h
#define ErrorPublicField_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class ErrorPublicField : public SyntaxError 
    {
    public:
        
        ErrorPublicField();

        ErrorPublicField(Reporter* const reporter, AstItem* const item, const string& name);

        virtual ~ErrorPublicField();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    private:
        /**
         * The name of the method.
         */
        string name_;

        /**
         * The length of the method.
         */
        int length_;

        /**
         * The maximum length for methods.
         */
        int limit_;

    };

}

#endif //! ErrorPublicField_h
