#ifndef ErrorPackageNameStandard_h
#include "ErrorPackageNameStandard.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

using namespace doctorj;

REGISTER_DESCRIPTION(ErrorPackageNameStandard);

ErrorPackageNameStandard::ErrorPackageNameStandard()
{
}

ErrorPackageNameStandard::ErrorPackageNameStandard(Reporter* const reporter, AstItem* const item) :
        NamingError(reporter, item)
{
}

ErrorPackageNameStandard::~ErrorPackageNameStandard()
{
}

string ErrorPackageNameStandard::title() const
{
    return "Package Name Standard Violation";
}

void ErrorPackageNameStandard::writeDescription(ostream& os) const
{
    os << "The standard for packages is for their names to be" << endl;
    os << "short and all lowercase." << endl;
}

string ErrorPackageNameStandard::message() const
{
    return "violation of standard for package names";
}
