#ifndef ErrorGenericCatch_h
#include "ErrorGenericCatch.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif


using namespace doctorj;

REGISTER_DESCRIPTION(ErrorGenericCatch);

ErrorGenericCatch::ErrorGenericCatch()
{
}

ErrorGenericCatch::ErrorGenericCatch(Reporter* const reporter, AstCatchClause* const cc) :
        SyntaxError(reporter, cc->getFormalParameter()), 
     type_(cc->getFormalParameter()->getType()->text())
{
}

ErrorGenericCatch::~ErrorGenericCatch()
{
}

string ErrorGenericCatch::title() const
{
    return "Overly General Exception Catch";
}

void ErrorGenericCatch::writeDescription(ostream& os) const
{
    os << "The catch statement is overly general." << endl;
}

string ErrorGenericCatch::message() const
{
    return "catching '" + type_ + "' is overly general";
}
