#ifndef ErrorExplicitSuperCall_h
#include "ErrorExplicitSuperCall.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

using namespace doctorj;

REGISTER_DESCRIPTION(ErrorExplicitSuperCall);

ErrorExplicitSuperCall::ErrorExplicitSuperCall()
{
}

ErrorExplicitSuperCall::ErrorExplicitSuperCall(Reporter* const reporter, AstExplicitConstructorInvocationSuper* const ec) :
        SyntaxError(reporter, ec)
{
}

ErrorExplicitSuperCall::~ErrorExplicitSuperCall()
{
}

string ErrorExplicitSuperCall::title() const
{
    return "Unnecessary Explicit Call to Superclass Constructor";
}

void ErrorExplicitSuperCall::writeDescription(ostream& os) const
{
    os << "The super() call to the superclass constructor is implicit" << endl;
}

string ErrorExplicitSuperCall::message() const
{
    return "super() does not need to be explicitly written for a constructor.";
}
