#ifndef ErrorExcessiveMethodLength_h
#include "ErrorExcessiveMethodLength.h"
#endif

#ifndef StringUtilities_h
#include "StringUtilities.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

using namespace doctorj;

REGISTER_DESCRIPTION(ErrorExcessiveMethodLength);

ErrorExcessiveMethodLength::ErrorExcessiveMethodLength()
{
}

ErrorExcessiveMethodLength::ErrorExcessiveMethodLength(Reporter* const reporter, AstItem* const item, 
                                                       const string& name, 
                                                       int length, 
                                                       int limit) :
        SyntaxError(reporter, item), name_(name), length_(length), limit_(limit)
{
}

ErrorExcessiveMethodLength::~ErrorExcessiveMethodLength()
{
}

string ErrorExcessiveMethodLength::title() const
{
    return "Excessively Long Method";
}

void ErrorExcessiveMethodLength::writeDescription(ostream& os) const
{
    os << "Method length exceeds guidelines." << endl;
}

string ErrorExcessiveMethodLength::message() const
{
    return "method '" + name_ + "' has " + StringUtilities::toString(length_) + 
        " lines, in excess of the guideline of " + StringUtilities::toString(limit_);
}
