#ifndef ErrorEmptyStatement_h
#include "ErrorEmptyStatement.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#include <ctype.h>

using namespace std;

using namespace doctorj;

ErrorEmptyStatement::ErrorEmptyStatement()
{
}

ErrorEmptyStatement::ErrorEmptyStatement(Reporter* const reporter, AstItem* const it) :
        SyntaxError(reporter, it)
{
}

ErrorEmptyStatement::~ErrorEmptyStatement()
{
}

string ErrorEmptyStatement::title() const
{
    string capkw(keyword());
    capkw[0] = toupper(capkw[0]);
    return "Empty " + capkw + " Statement";
}

void ErrorEmptyStatement::writeDescription(ostream& os) const
{
    os << "The " << keyword() << " statement contains no code." << endl;
}

string ErrorEmptyStatement::message() const
{
    return "the " + keyword() + " statement contains no code nor a comment denoting intent";
}
