#ifndef Test_h
#include "Test.h"
#endif

#ifndef ByteArray_h
#include "ByteArray.h"
#endif

#ifndef ZipFile_h
#include "ZipFile.h"
#endif

#ifndef Bc_h
#include "Bc.h"
#endif

#ifndef Platform_h
#include "Platform.h"
#endif

using namespace doctorj;


class BcZipFileReader : public Test 
{
public:
    BcZipFileReader(int argc, char** argv);
    virtual void run();
private:
    int argc_;
    char** argv_;
};


BcZipFileReader::BcZipFileReader(int argc, char** argv) : Test(true), argc_(argc), argv_(argv)
{
}

static void process(const string& zipName)
{
    cout << "processing " << zipName << endl;
    if (Platform::isReadableFile(zipName)) {
        ZipFile zf(zipName);
        vector<string> names = zf.entryNames();
        int nNames = names.size();
        for (int i = 0; i < nNames; ++i) {
            string name = names[i];
            if (names[i].find(".class") == names[i].length() - 6) {
                char* bytes  = NULL;
                int   nBytes = zf.getBytes(names[i], &bytes);
                cout << nBytes << "\t" << name << endl;
                ByteArrayBigEndian ba(bytes, nBytes);
                BcClassFileReader  rdr(&ba);
                BcTypeDeclaration* td = rdr.getType();
                cout << "-------------------------------------------------------" << endl;
                td->print();
                cout << "-------------------------------------------------------" << endl;
            }
        }
    }
    else {
        cout << zipName << ": not readable" << endl;
    }
}

void BcZipFileReader::run() 
{
    if (argc_ == 1) {
        process("/usr/java/lib/junit.jar");
    }
    else {
        for (int i = 1; i < argc_; ++i) {
            process(argv_[i]);
        }
    }
}

int main(int argc, char** argv) 
{
    BcZipFileReader t(argc, argv);
    t.run();
    cout << "zip file test results: " << t << endl;
    return t.nerrors();
}
