#ifndef Test_h
#include "Test.h"
#endif

#ifndef Bc_h
#include "Bc.h"
#endif

using namespace doctorj;


class BcDescriptorsTest : public Test 
{
public:
    BcDescriptorsTest(int argc, char** argv);
    virtual void run();
private:
    int argc_;
    char** argv_;
};


BcDescriptorsTest::BcDescriptorsTest(int argc, char** argv) : Test(true), argc_(argc), argv_(argv)
{
}

static void process(const string& type, int* const pos = NULL)
{
    cout << "processing " << type << endl;
    string desc = BcDescriptors::toDescriptor(type, pos);
    cout << "    '" << type << "' => '" << desc << "'" << endl;
}

void BcDescriptorsTest::run() 
{
    if (argc_ == 1) {
        process("I");
    }
    else {
        for (int i = 1; i < argc_; ++i) {
            string type(argv_[i]);
            int    len = type.length();
            int    pos = 0;
            while (pos < len) {
                process(type, &pos);
            }
        }
    }
}

int main(int argc, char** argv) 
{
    BcDescriptorsTest t(argc, argv);
    t.run();
    cout << "descriptors test results: " << t << endl;
    return t.nerrors();
}
