#ifndef Test_h
#include "Test.h"
#endif

#ifndef FileByteStream_h
#include "FileByteStream.h"
#endif

#ifndef Bc_h
#include "Bc.h"
#endif

#ifndef DebugOptions_h
#include "DebugOptions.h"
#endif

#ifndef Platform_h
#include "Platform.h"
#endif

using namespace doctorj;

REGISTER_DEBUG_OPTION('b', "Byte code (decompiling)");

class BcClassFileReaderTest : public Test 
{
public:
    BcClassFileReaderTest(int argc, char** argv);
    virtual void run();
private:
    int argc_;
    char** argv_;
};


BcClassFileReaderTest::BcClassFileReaderTest(int argc, char** argv) : Test(true), argc_(argc), argv_(argv)
{
}

static void process(const string& classFile)
{
    cout << "processing " << classFile << endl;
    if (Platform::isReadableFile(classFile)) {
        FileByteStreamBigEndian bs(classFile);
        BcClassFileReader       rdr(&bs);
        BcTypeDeclaration*      td(rdr.getType());
        cout << "-------------------------------------------------------" << endl;
        td->print();
        cout << "-------------------------------------------------------" << endl;
    }
    else {
        cout << classFile << ": not readable" << endl;
    }
}

void BcClassFileReaderTest::run() 
{
    cout << "setting option to b" << endl;
    DebugOptions::get()->set("b");
    if (argc_ == 1) {
        process("Numbers.class");
    }
    else {
        for (int i = 1; i < argc_; ++i) {
            process(argv_[i]);
        }
    }
}

int main(int argc, char** argv) 
{
    BcClassFileReaderTest t(argc, argv);
    t.run();
    cout << "class file test results: " << t << endl;
    return t.nerrors();
}
