#ifndef Test_h
#include "Test.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef Platform_h
#include "Platform.h"
#endif

#ifndef std_iterator
#define std_iterator
#include <iterator>
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

using namespace doctorj;

class JavaClassLoaderTest : public Test 
{
public:
    JavaClassLoaderTest(int argc, char** argv);
    virtual void run();
    virtual void process(const string& pkgName);
private:
    int argc_;
    char** argv_;
    JavaClassLoader* loader_;
};


JavaClassLoaderTest::JavaClassLoaderTest(int argc, char** argv) : Test(true), argc_(argc), argv_(argv)
{
}

void JavaClassLoaderTest::process(const string& pkgName)
{
    cout << "processing " << pkgName << endl;
    vector<string> types;
    loader_->getTypesInPackage(pkgName, &types);
    copy(types.begin(), types.end(), ostream_iterator<string>(cout, "\n"));
    cout << endl;
    cout << "-------------------------------------------------------" << endl;
}

void JavaClassLoaderTest::run() 
{
    string cp;
    Platform::getEnv("CLASSPATH", &cp);
    loader_ = JavaClassLoader::get(cp);
    if (argc_ == 1) {
        process("java.lang");
    }
    else {
        for (int i = 1; i < argc_; ++i) {
            process(argv_[i]);
        }
    }
}

int main(int argc, char** argv) 
{
    JavaClassLoaderTest t(argc, argv);
    t.run();
    cout << "class loader test results: " << t << endl;
    return t.nerrors();
}
