#ifndef JavadocCommentSpellCheck_h
#define JavadocCommentSpellCheck_h

#ifndef CommentSpellCheck_h
#include "CommentSpellCheck.h"
#endif

using namespace std;

namespace doctorj
{
    class Reporter;
    class File;

    /**
     * Checks description sections for spelling. Skips "<pre>" and "<code>"
     * sections.
     */
    class JavadocCommentSpellCheck : public CommentSpellCheck
    {
    public:
        static JavadocCommentSpellCheck* get(Reporter* const reporter);

        virtual ~JavadocCommentSpellCheck();
        
        virtual void checkComment(const string& desc,
                                  char* const descStart, 
                                  File* const sourceFile);

        /**
         * Called for a misspelled word.
         */
        virtual void wordMisspelled(const string& word, 
                                    int position, 
                                    const multimap<int, string>& nearMatches);
        
    protected:
        static JavadocCommentSpellCheck* instance_;

        JavadocCommentSpellCheck(Reporter* const reporter);

    private:
        Reporter* reporter_;
        
        /**
         * The start of the description.
         */
        char* descStart_;
        
        /**
         * The file whence this came.
         */
        File* sourceFile_;

    };
}

#endif //! JavadocCommentSpellCheck_h
