#ifndef JavadocAnalyzer_h
#define JavadocAnalyzer_h

#ifndef std_string
#define std_string
#include <string>
#endif

#ifndef Analyzer_h
#include "Analyzer.h"
#endif

using namespace std;

namespace doctorj
{
    class AstLeaf;
    class AstModifierList;
    class Reporter;

    /**
     * Performs very generic javadoc analysis, and forwards complaints to the
     * reporter.
     */
    class JavadocAnalyzer : public Analyzer
    {
    public:
        /**
         * Uses the given reporter, strict flag, and modifiers.
         */
        JavadocAnalyzer(Reporter* const reporter, 
                        AstModifierList* const modifiers);

        virtual ~JavadocAnalyzer();

        /**
         * Returns the access modifier, or NULL if none.
         */
        virtual AstLeaf* access() const;

        /**
         * Returns the modifiers of this thing.
         */
        virtual AstModifierList* modifiers() const;

        /**
         * The category of this analyzer, as a single character.
         */
        virtual char category() const;

        /**
         * Returns whether this has public access, and should be tested.
         */
        virtual bool hasPublicAccess() const;

        /**
         * Returns whether this has protected access, and should be tested.
         */
        virtual bool hasProtectedAccess() const;
    
        /**
         * Returns whether this has private access, and should be tested.
         */
        virtual bool hasPrivateAccess() const;
    
        /**
         * Returns whether this has package access, and should be tested.
         */
        virtual bool hasPackageAccess() const;
        
    protected:

        /**
         * Not useful for checking code. Only for invoking methods associated as
         * an analyzer, not the code itself.
         */
        JavadocAnalyzer();

        /**
         * The access for this thing.
         */
        AstLeaf* access_;

        /**
         * Modifiers of the thing being analyzed.
         */
        AstModifierList* modifiers_;

    };
}

#endif //! JavadocAnalyzer_h
