#ifndef JavadocAnalyzer_h
#include "JavadocAnalyzer.h"
#endif

#ifndef Reporter_h
#include "Reporter.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

using namespace doctorj;

JavadocAnalyzer::JavadocAnalyzer(Reporter* const reporter, 
                                 AstModifierList* const modifiers) :
        Analyzer(reporter), modifiers_(modifiers)
{
    access_ = modifiers ? JavaModifierList::getAccess(modifiers) : NULL;
}

JavadocAnalyzer::JavadocAnalyzer() : modifiers_(NULL)
{
}

JavadocAnalyzer::~JavadocAnalyzer()
{
}

AstLeaf* JavadocAnalyzer::access() const
{
    return access_;
}

AstModifierList* JavadocAnalyzer::modifiers() const
{
    return modifiers_;
}

char JavadocAnalyzer::category() const
{
    return 'D';
}

bool JavadocAnalyzer::hasPublicAccess() const
{
    AstLeaf* acs = access();
    return acs && dynamic_cast<AstPublic*>(acs);
}

bool JavadocAnalyzer::hasProtectedAccess() const
{
    AstLeaf* acs = access();
    return acs && dynamic_cast<AstProtected*>(acs);
}
    
bool JavadocAnalyzer::hasPrivateAccess() const
{
    AstLeaf* acs = access();
    return acs && dynamic_cast<AstPrivate*>(acs);
}
    
bool JavadocAnalyzer::hasPackageAccess() const
{
    AstLeaf* acs = access();
    return !acs;                // null == package
}
      
