#ifndef InterfaceDocumentationAnalyzer_h
#include "InterfaceDocumentationAnalyzer.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef DocumentationErrors_h
#include "DocumentationErrors.h"
#endif

using namespace doctorj;

InterfaceDocumentationAnalyzer::InterfaceDocumentationAnalyzer(Reporter* const reporter,
                                                               AstInterfaceDeclaration* const iface,
                                                               AstModifierList* const modifiers) :
        ClassInterfaceDocumentationAnalyzer(reporter, modifiers),
        interface_(iface)
{
    check();
}

InterfaceDocumentationAnalyzer::InterfaceDocumentationAnalyzer() :
        interface_(NULL)
{
}

InterfaceDocumentationAnalyzer::~InterfaceDocumentationAnalyzer()
{
}

string InterfaceDocumentationAnalyzer::type() const
{
    return "interface";
}

AstItem* InterfaceDocumentationAnalyzer::getSubject()
{
    AstIdentifier* subject = interface_ == NULL ? NULL : interface_->getIdentifier();
    return subject;
}

AstNoncode* InterfaceDocumentationAnalyzer::leadingNoncode()
{
    return interface_ == NULL ? NULL : interface_->leadingNoncode();
}

ErrorInvalidJavadocTag* InterfaceDocumentationAnalyzer::makeUnknownTagError(AstItem* const item, 
                                                                            const string& tag) const
{
    return new ErrorInvalidJavadocTagInterface(reporter(), item, tag);
}
