#ifndef AstPrinter_h
#include "AstPrinter.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef HierarchyTextPrinter_h
#include "HierarchyTextPrinter.h"
#endif

#ifndef HierarchyXMLPrinter_h
#include "HierarchyXMLPrinter.h"
#endif

using namespace doctorj;


AstPrinter::AstPrinter() : App("astj", "abstract syntax printer"), asXML_(false)
{
    buildOptions();
}

AstPrinter::~AstPrinter()
{
}

void AstPrinter::addOptions(yagol::AppOptionSet* const opts)
{
    opts->addOption("ast.xml", "whether to display the AST in XML", &asXML_);
}

void AstPrinter::execute(AstProject* const proj)
{
    HierarchyPrinter* printer = NULL;
    if (asXML_) {
        printer = new HierarchyXMLPrinter();
    }
    else {
        printer = new HierarchyTextPrinter();
    }
    proj->getProcessed(printer);
    delete printer;
}
