#ifndef UserPreferences_h
#define UserPreferences_h

#ifndef std_string
#define std_string
#include <string>
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

using namespace std;

namespace doctorj 
{
    /**
     * The user's preferences, a singleton since there is only one user.
     */
    class UserPreferences
    {
    public:
        friend ostream& operator<<(ostream& os, const UserPreferences& up);
        
        static UserPreferences* get();

        /**
         * Whether to produce output (error/warning) messages in long format
         * (AKA contextually). False means short format.
         */
        bool contextOutput;

        /**
         * The number of spaces per tab.
         */
        int tabWidth;

        /**
         * Advanced diagnostics and debugging.
         */
        string debug;

        /**
         * Whether to check documentation.
         */
        bool checkDocumentation;

        /**
         * Whether to check statistics.
         */
        bool checkStatistics;

        /**
         * Whether to check syntax.
         */
        bool checkSyntax;

        /**
         * The version of the Java code.
         */
        double javaVersion;

        /**
         * The maximum length of methods.
         */
        int maxMethodLength;

        string formatInstanceFinalPublic;

        string formatInstanceFinalProtected;

        string formatInstanceFinalPackage;

        string formatInstanceFinalPrivate;

        string formatInstanceNonfinalPublic;

        string formatInstanceNonfinalProtected;

        string formatInstanceNonfinalPackage;

        string formatInstanceNonfinalPrivate;

        string formatStaticFinalPublic;

        string formatStaticFinalProtected;

        string formatStaticFinalPackage;

        string formatStaticFinalPrivate;

        string formatStaticNonfinalPublic;

        string formatStaticNonfinalProtected;

        string formatStaticNonfinalPackage;

        string formatStaticNonfinalPrivate;

        /**
         * Shortcuts to the above strings. Always indexed so that [0] is AstPublic,
         * [1] is AstProtected, [2] is AstPackage, and [3] is AstPrivate. Verify this
         * with the constructor of this class.
         */
        void getFormats(bool isStatic, bool isFinal, string fmts[], int maxFmts) const;

        /**
         * The preferred order of type declarations within a class.
         */
        vector<string> typeOrder;

        /**
         * The class path, initialized to the value of the "CLASSPATH"
         * environment variable.
         */
        string classPath;

        /**
         * The source path.
         */
        string sourcePath;

        /**
         * Whether to fix errors.
         */
        bool fix;

        /**
         * The suffix for backup files.
         */
        string backupSuffix;

        /**
         * The directory for backup files.
         */
        string backupDirectory;

        /**
         * The end-of-line sequence to be used. Default is LF ('\n'), for Unix.
         * Also valid are CR ('\r') for Mac and CRLF ('\r\n') for Dos.
         */
        string eolnType;

    protected:
        UserPreferences();

        virtual ~UserPreferences();

        static UserPreferences* instance_;

        /**
         * Whether to produce output (error/warning) messages in long format
         * (AKA contextually). False means short format.
         */
        bool contextOutput_;

        /**
         * The number of spaces per tab.
         */
        int tabWidth_;

        /**
         * The formats, in the order ["instance", "static"], ["final",
         * "nonfinal"], ["public", "protected", "package", "private" ].
         */
        string formats[16];

    };
}

#endif //! UserPreferences_h
