#ifndef ProcessorSet_h
#include "ProcessorSet.h"
#endif

#ifndef DeleteObject_h
#include "DeleteObject.h"
#endif

#ifndef Reporter_h
#include "Reporter.h"
#endif

#ifndef Rule_h
#include "Rule.h"
#endif

#ifndef Log_h
#include "Log.h"
#endif

#ifndef iterext_h
#include "iterext.h"
#endif

#ifndef std_algorithm
#define std_algorithm
#include <algorithm>
#endif

using namespace std;
using namespace doctorj;

ProcessorSet::ProcessorSet(Reporter* const reporter) : reporter_(reporter)
{
}

ProcessorSet::~ProcessorSet()
{
    for_each(rules_.begin(), rules_.end(), DeleteObject());
}

void ProcessorSet::addRule(Rule* const rule)
{
    rules_.push_back(rule);
}

void ProcessorSet::process(AstCompilationUnit* const cu)
{
    EACH(vector<Rule*>, rules_, it) {
        Rule* rule = *it;
        rule->process(cu);
    }

    reporter_->flush();
}

void ProcessorSet::process(AstCompilationUnitEmpty* const cu)
{
    process((AstCompilationUnit*)cu);
}

void ProcessorSet::process(AstCompilationUnitImp* const cu)
{
    process((AstCompilationUnit*)cu);
}

void ProcessorSet::process(AstCompilationUnitImpTypes* const cu)
{
    process((AstCompilationUnit*)cu);
}

void ProcessorSet::process(AstCompilationUnitPkg* const cu)
{
    process((AstCompilationUnit*)cu);
}

void ProcessorSet::process(AstCompilationUnitPkgImp* const cu)
{
    process((AstCompilationUnit*)cu);
}

void ProcessorSet::process(AstCompilationUnitPkgImpTypes* const cu)
{
    process((AstCompilationUnit*)cu);
}

void ProcessorSet::process(AstCompilationUnitPkgTypes* const cu)
{
    process((AstCompilationUnit*)cu);
}

void ProcessorSet::process(AstCompilationUnitTypes* const cu)
{
    process((AstCompilationUnit*)cu);
}

