#ifndef Error_h
#include "Error.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef File_h
#include "File.h"
#endif

#ifndef StringEdit_h
#include "StringEdit.h"
#endif

#ifndef Reporter_h
#include "Reporter.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef UserPreferences_h
#include "UserPreferences.h"
#endif

#ifndef Log_h
#include "Log.h"
#endif

#ifndef std_stdio_h
#define std_stdio_h
#include <stdio.h>
#endif

#ifndef std_math_h
#define std_math_h
#include <math.h>
#endif

using namespace std;
using namespace doctorj;

Error::Error() : item_(NULL)
{
}

Error::Error(Reporter* const reporter, AstItem* const item) : 
        Check(reporter), item_(item)
{
}

Error::~Error()
{
}

AstItem* Error::item() const
{
    return item_;
}

void Error::process()
{
    LOG(2, "");
    string ident = id();
    bool suppressed = ErrorRegistry::isSuppressed(ident);
    if (suppressed) {
        // cout << "error is suppressed" << endl;
    }
    else {
        reporter()->report(this);
        
        UserPreferences* prefs = UserPreferences::get();
        if (prefs->fix) {
            fix();
        }
        else {
            // cout << "not configured to fix any errors" << endl;
        }
    }
}

void Error::fix()
{
    StringEdit* edit = getEdit();
    if (edit) {
        if (!needsConfirmation() || confirm(edit)) {
            // cout << "Error::fix(): adding edit" << endl;
            item_->sourceFile()->addEdit(edit);
        }
        else {
            // cout << "Error::fix(): fix rejected" << endl;
            delete edit;
        }
    }
    else {
        // cout << "Error::fix(): no fix returned" << endl;
    }
}

StringEdit* Error::getEdit()
{
    return NULL;
}

bool Error::needsConfirmation()
{
    return true;
}

bool Error::confirm(StringEdit* const edit)
{
    File* file = item_->sourceFile();

    cout << "SUGGESTED FIX" << endl;
    cout << "current:" << endl;
    edit->showUnedited(file);
    cout << endl;
    
    cout << "proposed:" << endl;
    edit->showEdited(file);
    cout << "=====" << endl;

    cout << "accept this change? [y/n] " << flush;
    string answer;
    getline(cin, answer);
    
    if (answer == "y") {
//         cout << "Error::confirm(): returning true" << endl;
        return true;
    }
    else {
//         cout << "Error::confirm(): returning false" << endl;
        return false;
    }
}
