#!/usr/bin/python
# -*- coding: UTF-8 -*-
###########################################################################
# displayconfig-common.py - description                                   #
# ------------------------------                                          #
#
###########################################################################
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
###########################################################################

import os
import os.path
import sys
from gettext import gettext as _
import time
import shutil
import signal

from execwithcapture import *
import xf86misc as xf86misc


def testX(xsetup, servertestpy):
    xserverbin = "/usr/X11R6/bin/XFree86"
    if not os.path.isfile(xserverbin):
        xserverbin = "/usr/X11R6/bin/Xorg"
    rc = False

    # Remove an stale X server lock
    try: os.remove("/tmp/.X9-lock")
    except OSError: pass

    # Try to find a safe tmp dir.
    tmp_dir = None
    if os.environ.get("TMPDIR") is not None:
        tmp_dir = os.environ.get("TMPDIR")
    if tmp_dir is None or not os.path.isdir(tmp_dir):
        tmp_dir = os.path.join(os.environ.get("HOME"),"tmp")
        if not os.path.isdir(tmp_dir):
            tmp_dir = "/tmp"
    working_tmp_dir = os.path.join(tmp_dir,"guidance."+str(os.getpid()))
    error_filename = os.path.join(working_tmp_dir,"testserver.xoutput")
    config_filename = os.path.join(working_tmp_dir,"testserver.config")
    auth_filename = os.path.join(working_tmp_dir,"xauthority")

    # Start the Xserver up with the new config file.
    try:
        # Create our private dir.
        os.mkdir(working_tmp_dir,0700)

        # Backup the XAUTHORITY environment variable.
        old_xauthority = os.environ.get("XAUTHORITY",None)

        # Write out the new config file.
        xsetup.writeXorgConfig(config_filename)

        os.system("xauth -f %s add :9 . `mcookie`" % (auth_filename,) )
        # FIXME:: -xf86config is nowhere in man X ??
        pid = os.spawnv(os.P_NOWAIT,"/bin/bash",\
            ["bash","-c","exec %s :9 -xf86config %s -auth %s &> %s" % \
                (xserverbin, config_filename, auth_filename, error_filename)])
        print "Got pid",pid

        # Wait for the server to show up.
        print str(os.waitpid(pid,os.WNOHANG))

        # Use our private xauthority file.
        os.environ["XAUTHORITY"] = auth_filename

        time.sleep(1) # Wait a sec.
        testserver = None
        while True:
            # Try connecting to the server.
            try:
                testserver = xf86misc.XF86Server(":9")
                break
            except xf86misc.XF86Error:
                testserver = None
            # Check if the server process is still alive.
            if os.waitpid(pid,os.WNOHANG) != (0,0):
                break
            time.sleep(1) # Give the server some more time.

        print "checkpoint 1"
        print str(testserver)

        if testserver is not None:
            # Start the timed popup on the :9 display.
            #servertestpy = str(KGlobal.dirs().findResource("data","guidance/servertestdialog.py"))
            #servertestpy = os.path.join(os.path.abspath(os.path.dirname(sys.argv[0])),"servertestdialog.py")
            testrc = os.system("python " + servertestpy + " '" + auth_filename+"' ")
            rc = os.WEXITSTATUS(testrc)
            testserver = None
            os.kill(pid,signal.SIGINT)
        else:
            # Server failed, read the error info.
            msg = ""
            try:
                fhandle = open(error_filename,'r')
                for line in fhandle.readlines():
                    if (line.startswith("(EE)") and ("Disabling" not in line)) or line.startswith("Fatal"):
                        msg += line
                msg = _("Messages from the X server:\n") + msg
            except IOError:
                msg += _("Sorry, unable to capture the error messages from the X server.")
            return (False,_("Sorry, this configuration video card driver\nand monitor doesn't appear to work:\n\n")+msg)

    finally:
        # Attempt some cleanup before we go.
        try: os.remove(error_filename)
        except OSError: pass
        try: os.remove(config_filename)
        except OSError: pass
        try: os.remove(auth_filename)
        except OSError: pass
        try: os.rmdir(working_tmp_dir)
        except OSError: pass

        if old_xauthority is None:
            del os.environ["XAUTHORITY"]
        else:
            os.environ["XAUTHORITY"] = old_xauthority

    return (rc==0,"")


def _findXorgConfig():
    # Lookup location of X configfile
    for line in ExecWithCapture("xset", ["xset","q"],True).split('\n'):
        if line.strip().startswith("Config file"):
            return line.split(":")[1].strip()
    # Sometimes, xset doesn't know about the configfile location, hence ...
    if os.path.isfile("/etc/X11/xorg.conf"):
        return "/etc/X11/xorg.conf"
    return None


