/* ============================================================
 * File  : plugin_mpegencoder.cpp
 * Author: Gilles Caulier <caulier dot gilles at free.fr>
 * Date  : 2003-09-02
 * Description : Images MPEG encoder plugin ('kimg2mpeg'
 *               program from 'kvcdtools' project 
 *               (http://kvcdtools.free.fr)
 *
 * Copyright 2003 by Gilles Caulier

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// Include files for Qt

#include <qpushbutton.h>
#include <qgroupbox.h>

// Include files for KDE

#include <klocale.h>
#include <kaction.h>
#include <kgenericfactory.h>
#include <klibloader.h>
#include <kconfig.h>
#include <kdebug.h>
#include <kmessagebox.h>

// Digikam includes

#include <digikam/albummanager.h>
#include <digikam/albuminfo.h>

// Local includes

#include "checkbinprog.h"
#include "plugin_mpegencoder.h"
#include "kimg2mpg.h"


K_EXPORT_COMPONENT_FACTORY( digikamplugin_mpegencoder,
                            KGenericFactory<Plugin_Mpegencoder>("digikam"));

// -----------------------------------------------------------

Plugin_Mpegencoder::Plugin_Mpegencoder(QObject *parent, const char*, const QStringList&)
    : Digikam::Plugin(parent, "MPEGEncoder")
{
    setInstance(KGenericFactory<Plugin_Mpegencoder>::instance());
    setXMLFile("plugins/digikamplugin_mpegencoder.rc");
    KGlobal::locale()->insertCatalogue("digikamplugin_mpegencoder");

    kdDebug() << "Plugin_Mpegencoder plugin loaded" << endl;

    (void) new KAction (i18n("MPEG Encoder..."),
                        "video",
                        0,
                        this,
                        SLOT(slotActivate()),
                        actionCollection(),
                        "mpeg_encoder");
}

/////////////////////////////////////////////////////////////////////////////////////////////

Plugin_Mpegencoder::~Plugin_Mpegencoder()
{
}

/////////////////////////////////////////////////////////////////////////////////////////////

void Plugin_Mpegencoder::slotActivate()
{
    Digikam::AlbumInfo *album = Digikam::AlbumManager::instance()->currentAlbum();
    KImg2mpgData *MPEGconverterDialog = new KImg2mpgData();
    MPEGconverterDialog->show();

    CheckBinProg* CheckExternalPrograms = new CheckBinProg(this);
    int ValRet = CheckExternalPrograms->findExecutables();

    if (ValRet == 0)
        MPEGconverterDialog->m_Encodebutton->setEnabled(false);

    if (ValRet == 2)
        MPEGconverterDialog->m_AudioInputFilename->setEnabled(false);

    if (album)
        {
        if (album->getSelectedItemsPath().isEmpty())
             MPEGconverterDialog->addItems(album->getAllItemsPath());
        else
             MPEGconverterDialog->addItems(album->getSelectedItemsPath());
        }
}



