/* ============================================================
 * File  : calselect.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-11-03
 * Description : 
 * 
 * Copyright 2003 by Renchi Raju

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef CALSELECT_H
#define CALSELECT_H

#include <qwidget.h>
#include <qptrvector.h>

class QSpinBox;

namespace DKCalendar
{

class MonthWidget;

class CalSelect : public QWidget
{
    Q_OBJECT

public:

    CalSelect(QWidget *parent, const char* name=0);
    ~CalSelect();

private:

    void setupView();
    
    QPtrVector<MonthWidget> *mwVector_;
    QSpinBox                *yearSpin_;

private slots:

    void slotYearChanged(int year);
 
};
    
}

#endif /* CALSELECT_H */
