use strict;
use warnings;
use Test::More;

# Ensure a recent version of Test::Pod::Coverage
my $min_tpc = 1.08;
eval "use Test::Pod::Coverage $min_tpc";
plan skip_all => "Test::Pod::Coverage $min_tpc required for testing POD coverage"
    if $@;

# Test::Pod::Coverage doesn't require a minimum Pod::Coverage version,
# but older versions don't recognize some common documentation styles
my $min_pc = 0.18;
eval "use Pod::Coverage $min_pc";
plan skip_all => "Pod::Coverage $min_pc required for testing POD coverage"
    if $@;
plan skip_all => "POD coverage is not full. set TEST_POD_COVERAGE if you want to see what is missing."
    unless $ENV{TEST_POD_COVERAGE};

all_pod_coverage_ok( { coverage_class => 'Pod::Coverage::CountParents' } );
