package com.tildemh.debbuggtk;

import com.tildemh.debbug.*;
import java.io.*;
import java.util.*;

/**
 * List of Listings which are being watched. This is used so that the package
 * list can be loaded and saved when needed. At some point, it will probably
 * also include detailes of which bug reports have been read, etc.
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: WatchedList.java,v 1.14 2004/03/21 13:57:40 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class WatchedList implements Serializable{

	private transient LinkedList items = new LinkedList();
	private ListingStub[] itemArray;

	/**
	 * Sun's jvm doesn't work with libc at the moment. GIJ doesn't seem to be
	 * working either. kaffe works fine... except it can't serialize
	 * LinkedLists. we convert them to arrays so all will be well.
	 */
	 private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException{
		 Object[] objs = items.toArray();
		 itemArray = new ListingStub[ objs.length ];
		 for (int i =0; i< objs.length; i++){
			 itemArray[i] = (ListingStub) objs[i];
		 }
		 out.defaultWriteObject();
	 }
	 /**
	  * Convert arrays back to linkedlists.
	  */
	 private void readObject(java.io.ObjectInputStream in) throws java.io.InvalidClassException, ClassNotFoundException, IOException{
		 in.defaultReadObject();
		 items = new LinkedList();
		 for(int i = 0; i < itemArray.length; i++){
			 items.addLast( itemArray[i] );
		 }
		 itemArray = null;
	 }

	 public void save() throws IOException{
		File dir =  new File( System.getProperty("user.home") +"/.debbug-java/bugwatcher/");
		if (!dir.exists()) dir.mkdirs();

		File f = new File( System.getProperty("user.home") +"/.debbug-java/bugwatcher/watched" );
		if (DebbugGtk.DEBUG)  System.out.println("DEBUG: writing watched list to "+f.toString() );
		
		ObjectOutputStream out = new ObjectOutputStream( new FileOutputStream(f) );

		out.writeObject(this);
		out.flush();
		out.close();

		if (DebbugGtk.DEBUG) System.out.println("DEBUG: Saved watch list");
	 }

	 public static WatchedList load() throws InvalidClassException, OptionalDataException, ClassNotFoundException, IOException{
		 File f = new File( System.getProperty("user.home") +"/.debbug-java/bugwatcher/watched" );
		
		if (!f.exists()) throw new IOException("Watched list doesn't exist");

		WatchedList list = null;
		ObjectInputStream in = new ObjectInputStream( new FileInputStream(f) );
		Object o = in.readObject();
		in.close();
		if (! (o instanceof WatchedList)){
			throw new InvalidClassException("WatchedList file not instance of WatchedList");
		}
		list = (WatchedList) o;
		return list;

	 }

	
	public WatchedList(){
		items = new LinkedList();
	}

	public void add(ListingStub item){
		if (DebbugGtk.DEBUG) System.out.println("Adding item "+item);
		items.add(item);	
		if (DebbugGtk.DEBUG) System.out.println("Adding item "+item);
	}

	/**
	 * Removes an item with identical Type and name
	 */
	public void remove(ListingStub item){

		for(int i = 0; i < items.size(); i++){
			if (item.equals( (ListingStub) items.get(i))){
				items.remove(i);
			}
		}
	}
			
	public LinkedList getItems(){
		return items;
	}

}
	
