package com.tildemh.debbuggtk;

import com.tildemh.debbug.*;
import org.gnu.gtk.*;
import org.gnu.gnome.*;
import org.gnu.gnome.event.*;

/**
 * Bug reporter page for Title and Severity
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: BRTitleSeverity.java,v 1.5 2004/04/21 20:20:04 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class BRTitleSeverity extends DruidPageStandard implements DruidPageSetupListener, DruidPageChangeListener {

	private boolean contentSet = false;
	private org.gnu.gtk.Entry title;
	private RadioButton sevCritical;
	private RadioButton sevGrave;
	private RadioButton sevSerious;
	private RadioButton sevImportant;
	private RadioButton sevNormal;
	private RadioButton sevMinor;
	private RadioButton sevWishlist;

	private SizeGroup sg;

	private BugReporter br;

	public BRTitleSeverity( BugReporter br ){
		super();
		this.br = br;
		addListener( (DruidPageSetupListener) this );
		addListener( (DruidPageChangeListener) this );
		setLogo( BugReporter.getLogo() );
	}


	public void druidPageSetupEvent( DruidPageSetupEvent event ){
		if ( event.isOfType( DruidPageSetupEvent.Type.PREPARE ) ){
			if (!contentSet){
				// make the page
				setTitle( "Bug Details" );

				VBox vb = getLayout();
				
				HBox hb = new HBox( false, 0);
				title = new org.gnu.gtk.Entry();
				hb.packStart( new Label("Title:") );
				hb.packStart( title, true, true, 0);
				vb.packStart( hb );

				sg = new SizeGroup( SizeGroupMode.HORIZONTAL );
				
				sevCritical = new RadioButton((RadioButton)null, "_Critical", true);
				addEntry( vb, sevCritical, new Label("makes unrelated software on the system (or the whole system) break, or causes serious data loss, or introduces a security hole on systems where you install the package.") );
				
				sevGrave = new RadioButton(sevCritical, "_Grave", true);
				addEntry( vb, sevGrave, new Label("makes the package in question unusable or mostly so, or causes data loss, or introduces a security hole allowing access to the accounts of users who use the package.  ") );
				
				sevSerious = new RadioButton(sevGrave, "_Serious", true);
				addEntry( vb, sevSerious, new Label("is a severe violation of Debian policy (that is, it violates a \"must\" or \"required\" directive), or, in the package maintainer's opinion, makes the package unsuitable for release.  ") );
				
				sevImportant = new RadioButton(sevSerious, "_Important", true);
				addEntry( vb, sevImportant, new Label("a bug which has a major effect on the usability of a package, without rendering it completely unusable to everyone.  ") );
				
				sevNormal = new RadioButton(sevImportant, "_Normal", true);
				addEntry( vb, sevNormal, new Label("the default value, applicable to most bugs.") );
				
				sevMinor = new RadioButton(sevNormal, "_Minor", true);
				addEntry( vb, sevMinor, new Label("a problem which doesn't affect the package's usefulness, and is presumably trivial to fix.  ") );
				
				sevWishlist = new RadioButton(sevMinor, "_Wishlist", true);
				addEntry( vb, sevWishlist, new Label("for any feature request, and also for any bugs that are very difficult to fix due to major design considerations.  ") );
				
				sevNormal.setState(true);
				contentSet = true;
				vb.showAll();
			}
		}
	}

	private void addEntry( VBox vb, Widget first, Label second ){
		HBox hb = new HBox( false, 0);
		hb.packStart( first, false, false, 0);
		second.setLineWrap(true);
		hb.packStart( second, true, true, 0 );
		vb.packStart( hb, true, true, 5 ); 
		sg.addWidget(first);
	}

	public boolean druidPageChangeEvent( DruidPageChangeEvent event ){
		if ( event.isOfType( DruidPageChangeEvent.Type.NEXT ) ){
			Bug bug = br.getBug();
			bug.setTitle( title.getText() );
			Severity s = null;
			if (sevCritical.getState()){
				s = Severity.CRITICAL;
			}else if (sevGrave.getState()){
				s = Severity.GRAVE;
			}else if (sevSerious.getState()){
				s = Severity.SERIOUS;
			}else if (sevImportant.getState()){
				s = Severity.IMPORTANT;
			}else if (sevNormal.getState()){
				s = Severity.NORMAL;
			}else if (sevMinor.getState()){
				s = Severity.MINOR;
			}else if (sevWishlist.getState()){
				s = Severity.WISHLIST;
			}
			bug.setSeverity( s );			
		}else if ( event.isOfType( DruidPageChangeEvent.Type.BACK ) ){
			br.titleSeverityBack();
			return true;
		}else if ( event.isOfType( DruidPageChangeEvent.Type.CANCEL ) ){
		}
		return false;
	}
	
}
