package com.tildemh.debbuggtk;

import org.gnu.gtk.*;
import org.gnu.gnome.*;
import org.gnu.gnome.event.*;

/**
 * Bug reporter page for tags &amp; other control info
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: BRTagsOther.java,v 1.4 2003/12/07 11:09:46 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class BRTagsOther extends DruidPageStandard implements DruidPageSetupListener, DruidPageChangeListener {

	private boolean contentSet = false;
	private CheckButton helpTag;
	private CheckButton patchTag;
	private CheckButton securityTag;
	private CheckButton upstreamTag;
	private CheckButton potatoTag;
	private CheckButton woodyTag;
	private CheckButton sargeTag;
	private CheckButton sidTag;
	private CheckButton experimentalTag;
	private CheckButton fixedTag;
	private CheckButton pendingTag;
	private CheckButton unreproducibleTag;
	
	private CheckButton d_iTag;
	private CheckButton confirmedTag;
	private CheckButton ipv6Tag;
	private CheckButton lfsTag;
	private CheckButton wontfixTag;
	private CheckButton moreinfoTag;

	private org.gnu.gtk.Entry forwarded;

	private BugReporter br;

	public BRTagsOther( BugReporter br ){
		super();
		addListener( (DruidPageSetupListener) this );
		addListener( (DruidPageChangeListener) this );
		setLogo( BugReporter.getLogo() );
		this.br = br;
	}


	public void druidPageSetupEvent( DruidPageSetupEvent event ){
		if ( event.isOfType( DruidPageSetupEvent.Type.PREPARE ) ){
			if (!contentSet){
				// make the page
				setTitle("Bug Details...");
				VBox vb = getLayout();
				helpTag = new CheckButton("_Help", true);
				patchTag = new CheckButton("_Patch", true);
				securityTag = new CheckButton("_Security", true);
				upstreamTag = new CheckButton("_Upstream", true);
				potatoTag = new CheckButton("P_otato", true);
				woodyTag = new CheckButton("_Woody", true);
				sargeTag = new CheckButton("S_arge", true);
				sidTag = new CheckButton("S_id", true);
				experimentalTag = new CheckButton("E_xperimental", true);
				fixedTag = new CheckButton("_Fixed", true);
				pendingTag = new CheckButton("P_ending", true);
				unreproducibleTag = new CheckButton("U_nreproducible", true);

				d_iTag = new CheckButton( "_D-I", true );
				confirmedTag = new CheckButton( "_Confirmed", true );
				ipv6Tag = new CheckButton( "_IPV6", true );
				lfsTag = new CheckButton( "_LFS", true );
				wontfixTag = new CheckButton( "Wontfi_x", true );
				moreinfoTag = new CheckButton( "_Moreinfo", true );

				vb.packStart( new Label( "Initial Bug Tags: (Ignore this page if you don't understand)"), false, false, 0);
//				vb.packStart( helpTag, true, true, 0 );
				vb.packStart( patchTag, true, true, 0 );
				vb.packStart( securityTag, true, true, 0 );
				vb.packStart( upstreamTag, true, true, 0 );
//				vb.packStart( fixedTag, true, true, 0 );
				vb.packStart( pendingTag, true, true, 0 );
//				vb.packStart( unreproducibleTag, true, true, 0 );
//				vb.packStart( confirmedTag, true, true, 0 );
//				vb.packStart( wontfixTag, true, true, 0 );
//				vb.packStart( moreinfoTag, true, true, 0 );
// commented items shouldn't really be tagged when creating the bug

				HBox hb = new HBox( true, 0);
				hb.packStart( d_iTag );
				hb.packStart( ipv6Tag );
				hb.packStart( lfsTag );
				vb.packStart( hb, true, true, 0 );
				
				vb.packStart( new Label("Debian releases involved: ") );
				hb = new HBox( true, 0);
				hb.packStart( potatoTag );
				hb.packStart( woodyTag );
				hb.packStart( sargeTag );
				hb.packStart( sidTag );
				hb.packStart( experimentalTag );
				vb.packStart( hb, true, true, 0 );

				
				hb = new HBox( true, 0);
				hb.packStart( new Label( "Forwarded: " ), false, false, 0);
				forwarded = new org.gnu.gtk.Entry();
				hb.packStart( forwarded, true, true, 0 );
				vb.packStart( hb, true, true, 0 );

				vb.showAll();
				contentSet = true;
			}
		}
	}

	public boolean druidPageChangeEvent( DruidPageChangeEvent event ){
		if ( event.isOfType( DruidPageChangeEvent.Type.NEXT ) ){
		}else if ( event.isOfType( DruidPageChangeEvent.Type.BACK ) ){
		}else if ( event.isOfType( DruidPageChangeEvent.Type.CANCEL ) ){
		}
		return false;
	}
	
}
