/***************************************************************************
                          dcwidget.cpp  -  description
                             -------------------
    begin                : Don Mai 30 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>

#include <qapplication.h>
#include <qstyle.h>
#include <qpainter.h>
#include <qheader.h>
#include <private/qinternal_p.h>

#include "dcwidget.h"

#include "dctransferview.h"

#include <dclib/dcos.h>

/** */
DC_UserListItem::DC_UserListItem( QListView *parent, const QString &text, const QPixmap & p )
	: DC_QCheckListItem( parent, text, p )
{
	int i;

	for(i=0;i<USERLISTITEM_MAX_COLUMNS;i++)
	{
		m_nCompareValue[i] = 0;
	}

	setCompareValue(0,text);
}

/** */
DC_UserListItem::DC_UserListItem( QListView *parent, const QString &text, Type tt )
	: DC_QCheckListItem( parent, text, tt )
{
	int i;

	for(i=0;i<USERLISTITEM_MAX_COLUMNS;i++)
	{
		m_nCompareValue[i] = 0;
	}

	setCompareValue(0,text);
}

/** */
void DC_UserListItem::setCompareValue( int column, const QString & text )
{
	QString s;
	const char * b;

	s = text.leftJustify(8,0x01,TRUE).lower();
	b = s.ascii();

	m_nCompareValue[column] = b[0] << 24 | b[1] << 16 | b[2] << 8 | b[3];
	m_nCompareValue[column] <<= 32;
	m_nCompareValue[column] |= b[4] << 24 | b[5] << 16 | b[6] << 8 | b[7];
}

/** */
int DC_UserListItem::compare( QListViewItem * i, int col, bool ascending ) const
{
	if ( col >= USERLISTITEM_MAX_COLUMNS )
	{
		return DC_QCheckListItem::compare(i,col,ascending);
	}

	// numeric compare
	if ( m_bSortTop && !((DC_QCheckListItem*)i)->m_bSortTop )
		return ascending ? -1 : 1;
	else if ( !m_bSortTop && ((DC_QCheckListItem*)i)->m_bSortTop )
		return ascending ? 1 : -1;
	else if ( m_nCompareValue[col] > ((DC_UserListItem*)i)->m_nCompareValue[col] )
		return 1;
	else if ( m_nCompareValue[col] < ((DC_UserListItem*)i)->m_nCompareValue[col] )
		return -1;
	else
		return DC_QCheckListItem::compare(i,col,ascending);
}

/** */
void DC_UserListItem::setText( int column, const QString & text )
{
	if ( column < USERLISTITEM_MAX_COLUMNS )
	{
		setCompareValue(column,text);
	}

	DC_QCheckListItem::setText(column,text);
}

/** */
DC_QCheckListItem::DC_QCheckListItem( QListView *parent, const QString &text, const QPixmap & p )
	: QCheckListItem( parent, text, p )
{
	colorText = parent->colorGroup().text();

	m_bSortTop = FALSE;
}

/** */
DC_QCheckListItem::DC_QCheckListItem( QListView *parent, const QString &text, Type tt )
	: QCheckListItem( parent, text, tt )
{
	colorText = parent->colorGroup().text();

	m_bSortTop = FALSE;
}

/** */
void DC_QCheckListItem::paintCell( QPainter * p, const QColorGroup & cg, int column, int width, int align )
{
	if ( column == 0 )
	{
		QColorGroup _cg(cg);

		_cg.setColor( QColorGroup::Text, colorText );

		QCheckListItem::paintCell( p, _cg, column, width, align );
	}
	else
	{
		QCheckListItem::paintCell( p, cg, column, width, align );
	}
}

/** */
int DC_QCheckListItem::compare( QListViewItem * i, int col, bool ascending ) const
{
	if( col == DC_QNumericSortItem::mycol )
	{
		// numeric compare
		if ( m_bSortTop && !((DC_QCheckListItem*)i)->m_bSortTop )
			return ascending ? -1 : 1;
		else if ( !m_bSortTop && ((DC_QCheckListItem*)i)->m_bSortTop )
			return ascending ? 1 : -1;
		else
			return DC_QNumericSortItem::mycompare(((DC_QCheckListItem*)i)->myvalue,myvalue,col,ascending);
	}
	else
	{
		if ( m_bSortTop && !((DC_QCheckListItem*)i)->m_bSortTop )
			return ascending ? -1 : 1;
		else if ( !m_bSortTop && ((DC_QCheckListItem*)i)->m_bSortTop )
			return ascending ? 1 : -1;
		else
			return QListViewItem::compare(i,col,ascending);
	}
}

/** */
QString DC_QCheckListItem::key( int column, bool /*ascending*/ ) const
{
	return text( column ).lower();
}

/** */
int DC_QListViewItem::compare( QListViewItem * i, int col, bool ascending ) const
{
	if(col==DC_QNumericSortItem::mycol)
		return DC_QNumericSortItem::mycompare(((DC_QListViewItem*)i)->myvalue,myvalue,col,ascending);
	else
		return QListViewItem::compare(i,col,ascending);
}

/** */
int DC_QNumericSortItem::mycompare( ulonglong v1, ulonglong v2, int , bool ) const
{
	if(v1<v2) return -1;
	else if(v1==v2) return 0;
	else return 1;
}

/** */
QString DC_QListViewItem::key( int column, bool /*ascending*/ ) const
{
	return text( column ).lower();
}

/** */
void DC_ListResult::paintCell( QPainter * p, const QColorGroup & cg, int column, int width, int align )
{
	QColorGroup _cg( cg );
	QColor c = _cg.text();

	if ( column == 3 ) // nick
	{
		if ( g_pTransferView->IsUserInQueue( text(3), text(5) ) )
		{
			c = blue;
		}
	}

	_cg.setColor( QColorGroup::Text, c );

	QListViewItem::paintCell( p, _cg, column, width, align );
}

/** */
DC_QProgressListItem::DC_QProgressListItem( DC_QProgressListItem *parent, const QString &text,
				int co, Type tt)
    : QListViewItem( parent, text, QString::null )
{
	m_nColumn = co;
	myType = tt;
	init();
}

/** */
DC_QProgressListItem::DC_QProgressListItem( QListViewItem *parent, const QString &text,
				int co, Type tt )
    : QListViewItem( parent, text, QString::null )
{
	m_nColumn = co;
	myType = tt;
	init();
}

/** */
DC_QProgressListItem::DC_QProgressListItem( QListView *parent, const QString &text,
				int co, Type tt )
    : QListViewItem( parent, text )
{
	m_nColumn = co;
	myType = tt;
	init();
}

/** */
int DC_QProgressListItem::RTTI = 1;

/** */
int DC_QProgressListItem::rtti() const
{
	return RTTI;
}

/** */
void DC_QProgressListItem::init()
{
	exclusive = 0;
	// init progress bar
	m_ProgressBar = new QProgressBar(0);
	m_bProgressEnable = TRUE;
	m_ProgressBar->setIndicatorFollowsStyle(FALSE);
	resetProgress();
}

/** */
void DC_QProgressListItem::resetProgress()
{
	m_ProgressBar->reset();
	m_ProgressBar->setTotalSteps(100);
}

/** */
void DC_QProgressListItem::setProgress( int i )
{
	m_ProgressBar->setProgress(i);
}

/** */
DC_QProgressListItem::~DC_QProgressListItem()
{
	exclusive = 0; // so the children won't try to access us.
	delete m_ProgressBar;
}

/** */
void DC_QProgressListItem::setup()
{
	QListViewItem::setup();
	int h = QListViewItem::height();
	//h = QMAX( listView()->style().pixelMetric(QStyle::PM_ProgressBarChunkWidth, listView()), h );
	//h = QMAX( h, QApplication::globalStrut().height() );
	setHeight( h );
	m_ProgressBar->setFixedHeight(h-listView()->itemMargin());
	m_ProgressBar->setFixedWidth(40);
}

/** */
int DC_QProgressListItem::width( const QFontMetrics& fm, const QListView* lv, int column) const
{
	int r = QListViewItem::width( fm, lv, column );
	if ( (column == m_nColumn) && (m_bProgressEnable == TRUE) ) {
		r += lv->itemMargin();
		if ( myType == Controller && pixmap( 0 ) ) {
		//	     r += 0;
		} else {
			r +=  lv->style().pixelMetric(QStyle::PM_ProgressBarChunkWidth, lv) + 4;
		}
	}

	return QMAX( r, QApplication::globalStrut().width() );
}

/*!
    Paints the item using the painter \a p and the color group \a cg.
    The item is in column \a column, has width \a width and has
    alignment \a align. (See Qt::AlignmentFlags for valid alignments.)
*/
void DC_QProgressListItem::paintCell( QPainter * p, const QColorGroup & cg,
			       int column, int width, int align )
{
	if ( !p )
		return;

	QListView *lv = listView();
	if ( !lv )
		return;

	const BackgroundMode bgmode = lv->viewport()->backgroundMode();
	const QColorGroup::ColorRole crole = QPalette::backgroundRoleFromMode( bgmode );

	// we are not friends ...
//	if ( cg.brush( crole ) != lv->colorGroup().brush( crole ) )
		p->fillRect( 0, 0, width, QListViewItem::height(), cg.brush( crole ) );
//	else
//		paintEmptyArea( p, QRect( 0, 0, width, QListViewItem::height() ) );

	if ( (column != m_nColumn) || (m_bProgressEnable == FALSE) )
	{
		// The rest is text, or for subclasses to change.
		QListViewItem::paintCell( p, cg, column, width, align );
		return;
	}

	int marg = lv->itemMargin();
	int r = marg;

	int boxsize = lv->style().pixelMetric(QStyle::PM_ProgressBarChunkWidth, lv);
	QFontMetrics fm( lv->fontMetrics() );

	bool parentControl = FALSE;
	if ( QListViewItem::parent() && QListViewItem::parent()->rtti() == 1  &&
	   ((DC_QProgressListItem*) QListViewItem::parent())->type() == Controller )
		parentControl = TRUE;

	int styleflags = QStyle::Style_Default;

	if ( isSelected() )
		styleflags |= QStyle::Style_Selected;
	if ( QListViewItem::isEnabled() && lv->isEnabled() )
		styleflags |= QStyle::Style_Enabled;

	if ( myType == ProgressBar )
	{
		p->save();

		int x = 0;
		if(!parentControl)
			x += 3;

		QRect bar;
		bar = m_ProgressBar->contentsRect();
		bar.setWidth(40);
		QSharedDoubleBuffer * buffer = new QSharedDoubleBuffer( p, bar.x(), bar.y(), bar.width(), bar.height() );
#if QT_VERSION >= 0x030100
		QPoint pn = m_ProgressBar->backgroundOffset();
		buffer->painter()->setBrushOrigin( -pn.x(), -pn.y() );
#endif
		const QPixmap *bpm = m_ProgressBar->paletteBackgroundPixmap();
		if ( bpm )
			buffer->painter()->fillRect( bar, QBrush( m_ProgressBar->paletteBackgroundColor(), *bpm ) );
		else
			buffer->painter()->fillRect( bar, m_ProgressBar->paletteBackgroundColor() );
		buffer->painter()->setFont( p->font() );

		//bar = QStyle::visualRect(m_ProgressBar->style().subRect(QStyle::SR_ProgressBarGroove, m_ProgressBar), m_ProgressBar );
		m_ProgressBar->style().drawControl(QStyle::CE_ProgressBarGroove, buffer->painter(), m_ProgressBar,
			bar,
			m_ProgressBar->colorGroup(), styleflags);

		//bar = QStyle::visualRect(m_ProgressBar->style().subRect(QStyle::SR_ProgressBarContents, m_ProgressBar), m_ProgressBar );
		m_ProgressBar->style().drawControl(QStyle::CE_ProgressBarContents, buffer->painter(), m_ProgressBar,
			bar,
			m_ProgressBar->colorGroup(), styleflags);

		if (m_ProgressBar->percentageVisible())
		{
			//bar = QStyle::visualRect(m_ProgressBar->style().subRect(QStyle::SR_ProgressBarLabel, m_ProgressBar), m_ProgressBar );
			m_ProgressBar->style().drawControl(QStyle::CE_ProgressBarLabel, buffer->painter(), m_ProgressBar,
			    bar,
			    m_ProgressBar->colorGroup(), styleflags);
		}
		r += boxsize + bar.width();

		p->restore();

		delete buffer;
	}

	if ( align == AlignCenter )
	{
		QFontMetrics fm( lv->font() );
		r += (width - boxsize - fm.width(text()))/2;
		// the text should not be centered when we have a centered checkbox
		align &= ~AlignCenter;
	}

	p->translate( r, 0 );
	p->setPen( QPen( cg.text() ) );
	QListViewItem::paintCell( p, cg, column, width - r, align );
}

/*!
    Draws the focus rectangle \a r using the color group \a cg on the
    painter \a p.
*/
void DC_QProgressListItem::paintFocus( QPainter *p, const QColorGroup & cg,
				 const QRect & r )
{
	bool intersect = TRUE;
	QListView *lv = listView();

	if ( lv && lv->header()->mapToActual( 0 ) != 0 )
	{
		int xdepth = lv->treeStepSize() * ( depth() + ( lv->rootIsDecorated() ? 1 : 0) ) + lv->itemMargin();
		int p = lv->header()->cellPos( lv->header()->mapToActual( 0 ) );
		xdepth += p;
		intersect = r.intersects( QRect( p, r.y(), xdepth - p + 1, r.height() ) );
	}

	bool parentControl = FALSE;

	if ( QListViewItem::parent() && QListViewItem::parent()->rtti() == 1  &&
	   ((DC_QProgressListItem*) QListViewItem::parent())->type() == Controller )
		parentControl = TRUE;

	if ( myType != Controller && intersect &&
	   (lv->rootIsDecorated() || myType == RadioButton || myType == ProgressBar ||
	   (myType == CheckBox && parentControl) ) )
	{
		QRect rect;
		int boxsize = 0; //lv->style().pixelMetric(QStyle::PM_ProgressBarChunkWidth, lv);
		if ( lv->columnAlignment(0) == AlignCenter )
		{
			QFontMetrics fm( lv->font() );
			int bx = (lv->columnWidth(0) - (boxsize + fm.width(text())))/2 + boxsize;
			if ( bx < 0 ) bx = 0;
			rect.setRect( r.x() + bx /*+ 5*/, r.y(), r.width() - bx /*- 5*/, r.height() );
		} else
			rect.setRect( r.x() + boxsize /*+ 5*/, r.y(), r.width() - boxsize /*- 5*/, r.height() );
		QListViewItem::paintFocus(p, cg, rect);
	}
	else
	{
		QListViewItem::paintFocus(p, cg, r);
	}
}
