/***************************************************************************
                          dctransferview.cpp  -  description
                             -------------------
    begin                : Sat Feb 23 2002
    copyright            : (C) 2002-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlistview.h>
#include <qstringlist.h>
#include <qcursor.h>
#include <qpopupmenu.h>
#include <qtabwidget.h>
#include <qmessagebox.h>
#include <qtextedit.h>
#include <qdatetime.h>
#include <qlabel.h>
#include <qinputdialog.h>
#include <qtimer.h>
#include <qworkspace.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qregexp.h>
#include <qptrlist.h>
#include <qvaluevector.h>
#include <qlayout.h>

#include <dcconfig.h>
#include <dcfilebrowser.h>
#include <dcconnectionmanager.h>
#include <dcmenuhandler.h>
#include <dcfiletool.h>
#include <dcfiletransferinfo.h>
#include <dcevent.h>
#include <dcqtextedit.h>

#include "dctransferview.h"
#include "dchubsearch.h"
#include "dcclient.h"
#include "dcgui.h"
#include "dcedittransfer.h"
#include "dciconloader.h"

#include <dclib/cdownloadqueue.h>
#include <dclib/cdownloadmanager.h>
#include <dclib/dcos.h>
#include <dclib/cutils.h>

#define TIMER_BASE 500

DCTransferView * g_pTransferView = 0;

/** */
DCTransferView::DCTransferView(QWidget* parent, const char *name, int wflags) : DCDialogTransfer(parent, name, wflags)
{
	int idx;

	// set default icon
	setIcon( g_pIconLoader->GetPixmap(eiTRANSFER) );

	// set the ColumnWidthMode to manual, we will take care of this task
	for( idx = 0; idx < ListView_TRANSFER->columns(); idx++ )
	{
		ListView_TRANSFER->setColumnWidthMode( idx, QListView::Manual );
	}
	for( idx = 0; idx < ListView_TRANSFERWAIT->columns(); idx++ )
	{
		ListView_TRANSFERWAIT->setColumnWidthMode( idx, QListView::Manual );
	}
	for( idx = 0; idx < ListView_LOCALFILES->columns(); idx++ )
	{
		ListView_LOCALFILES->setColumnWidthMode( idx, QListView::Manual );
	}
	for( idx = 0; idx < ListView_SLOTS->columns(); idx++ )
	{
		ListView_SLOTS->setColumnWidthMode( idx, QListView::Manual );
	}

	pFileList         = new CList<DCFileBrowser>();
	pMessageList      = new CList<CObject>;
	pQueueList        = new CThreadStringList();
	pQueueLocalList   = new CThreadStringList();
	pViewTransferList = new CThreadStringList();

	Timer = new QTimer;
	Thread = new CThread;

	InitDocument();

	g_pTransferView = this;
}

/** */
DCTransferView::~DCTransferView()
{
	DCFileBrowser * FileList;

	g_pTransferView = NULL;

	ListView_TRANSFERWAIT->removeEventFilter(this);
	removeEventFilter(ListView_TRANSFERWAIT);

	if ( Timer )
	{
		Timer->stop();
		delete Timer;
	}

	Thread->Lock();

	// clear filelist
	while ( (FileList=pFileList->Next(0)) != 0 )
	{
		// remove from the list
		pFileList->Remove(FileList);
		delete FileList;
	}

	delete pFileList;
	pFileList = 0;

	ListView_TRANSFERWAIT->clear();
	ListView_LOCALFILES->clear();

	if ( pMessageList )
	{
		delete pMessageList;
		pMessageList = 0;
	}

	if ( pQueueList )
	{
		delete pQueueList;
		pQueueList = 0;
	}

	if ( pQueueLocalList )
	{
		delete pQueueLocalList;
		pQueueLocalList = 0;
	}

	if ( pViewTransferList )
	{
		delete pViewTransferList;
		pViewTransferList = 0;
	}

	DLM_SaveQueue();

	Thread->UnLock();

	delete Thread;
	Thread = 0;
}

/** */
void DCTransferView::SetWorkspace( QWidget* workspace )
{
	pWorkspace = (QWorkspace*)workspace;
}

/** */
void DCTransferView::InitDocument()
{
	StringMap * map;

	// on create set tab width
	ResizeListViewColumn();

	// init log tab
	QGridLayout * tll = new QGridLayout( Frame_LOG, 1, 1, 4, 4, "tabLayoutLog");
	m_pTextEdit_LOG = new DCQTextEdit( Frame_LOG, "TextEdit_LOG" );
	m_pTextEdit_LOG->setReadOnly( TRUE );
	tll->addWidget( m_pTextEdit_LOG, 0, 0 );

	// install event filters
	ListView_TRANSFERWAIT->installEventFilter(this);
	installEventFilter(ListView_TRANSFERWAIT);

	// default setting
	if ( g_pConfig->GetMap("TRANSFERVIEW",map) == FALSE )
	{
		// view is docked
		(*map)["DOCKED"] = QString("1");
	}

	connect( TabWidget_TRANSFER,SIGNAL(currentChanged(QWidget*)), this, SLOT(slotTabWidgetCurrentChange(QWidget*)) );
	connect( ListView_TRANSFER, SIGNAL(contextMenuRequested( QListViewItem *, const QPoint &, int )), this, SLOT(slotRightButtonClickedTransferList(QListViewItem*, const QPoint &, int )) );
	connect( ListView_TRANSFERWAIT, SIGNAL(contextMenuRequested( QListViewItem *, const QPoint &, int )), this, SLOT(slotRightButtonClickedTransferWaitList(QListViewItem*, const QPoint &, int )) );
	connect( ListView_LOCALFILES, SIGNAL(contextMenuRequested( QListViewItem *, const QPoint &, int )), this, SLOT(slotRightButtonClickedLocalFilesList(QListViewItem*, const QPoint &, int )) );
	connect( ListView_TRANSFERWAIT,SIGNAL(doubleClicked(QListViewItem*)), this, SLOT(slotDoubleClickedTransferWaitList(QListViewItem*)) );
	connect( ListView_SLOTS, SIGNAL(contextMenuRequested( QListViewItem *, const QPoint &, int )), this, SLOT(slotRightButtonClickedUserSlotList(QListViewItem*, const QPoint &, int )) );
	connect( m_pTextEdit_LOG, SIGNAL(rightButtonClicked( const QPoint& )), this, SLOT(slotRightButtonClickedLog( const QPoint& )) );

	connect( Timer, SIGNAL(timeout()), this, SLOT(timerDone()) );

	Timer->start( TIMER_BASE, TRUE );
}

/** */
void DCTransferView::DeInitDocument()
{
	// deinit transferview
	StringMap * map;

	// save hub view settings
	g_pConfig->GetMap("HUBVIEW",map);
}

/** */
bool DCTransferView::eventFilter( QObject * object, QEvent * event )
{
	DCFileBrowser * FileList;

	if( (event->type() == QEvent::Close) &&
	    ((DCTransferView*)object!=this) &&
	    ((QListView*)object!=ListView_TRANSFERWAIT) )
	{
		// file list closed
		Thread->Lock();

		if ( pFileList != 0 )
		{
			((DCFileBrowser *)object)->showNormal();
			FileList = (DCFileBrowser *)object;
			pFileList->Remove(FileList);
		}

		Thread->UnLock();
	}

	return QWidget::eventFilter( object, event );    // standard event processing
}

/** current tab widget change slot */
void DCTransferView::slotTabWidgetCurrentChange(QWidget*)
{
//	ResizeListViewColumn();
}

/** overridden so that the columns are resized on show() */
void DCTransferView::show()
{
	QWidget::show();

	ResizeListViewColumn();
}

/** resize event handler */
void DCTransferView::resizeEvent( QResizeEvent * )
{
	ResizeListViewColumn();
}

/** resize the ListView columns */
void DCTransferView::ResizeListViewColumn()
{
	int width = 0;

	if ( ListView_TRANSFER->isVisible() )
	{
		width = ListView_TRANSFER->width();
	}
	else if ( ListView_TRANSFERWAIT->isVisible() )
	{
		width = ListView_TRANSFERWAIT->width();
	}
	else if ( ListView_LOCALFILES->isVisible() )
	{
		width = ListView_LOCALFILES->width();
	}
	else if ( ListView_SLOTS->isVisible() )
	{
		width = ListView_SLOTS->width();
	}

	if ( width > 0 )
	{
		ListView_TRANSFER->setColumnWidth( 0, ((width*1)/9) );
		ListView_TRANSFER->setColumnWidth( 1, ((width*1)/9) );
		//ListView_TRANSFER->setColumnWidth( 2, ((width*1)/11) );
//		ListView_TRANSFER->setColumnWidth( 3, ((width*1)/12) );
		ListView_TRANSFER->setColumnWidth( 2, ((width*3)/9) );
		ListView_TRANSFER->setColumnWidth( 3, ((width*2)/9) );
		ListView_TRANSFER->setColumnWidth( 4, ((width*2)/9) );

		ListView_TRANSFERWAIT->setColumnWidth( 0, ((width*4 )/24) );
		ListView_TRANSFERWAIT->setColumnWidth( 1, ((width*11)/24) );
		ListView_TRANSFERWAIT->setColumnWidth( 2, ((width*5 )/24) );
		ListView_TRANSFERWAIT->setColumnWidth( 3, ((width*4 )/24) );

		ListView_LOCALFILES->setColumnWidth( 0, ((width*5)/11) );
		ListView_LOCALFILES->setColumnWidth( 1, ((width*2)/11) );
		ListView_LOCALFILES->setColumnWidth( 2, ((width*3)/11) );
		ListView_LOCALFILES->setColumnWidth( 1, ((width*3)/11) );

		ListView_SLOTS->setColumnWidth( 0, ((width*3)/9) );
		ListView_SLOTS->setColumnWidth( 1, ((width*3)/9) );
		ListView_SLOTS->setColumnWidth( 2, ((width*3)/9) );
	}
}

/** download manager callback function */
int DCTransferView::DC_DownloadManagerCallBack( CObject * Object )
{
	int err = -1;

	if ( Thread == 0 )
	{
		return err;
	}
	
	Thread->Lock();

	if ( Object != NULL )
	{
		if ( pMessageList != 0 )
		{
			pMessageList->Add(Object);
			err = 0;
		}
		else
		{
			err = -1;
		}
        }
	else
	{
		err = -1;
	}

	Thread->UnLock();

	return err;
}

/** */
void DCTransferView::timerDone()
{
	CObject * Object;
	CDCMessage *DCMsg;
	bool bLVWaitUpdate = FALSE;
	int i;

	for(i=0;i<50;i++)
	{
		if ( Thread->TryLock() == FALSE )
		{
			break;
		}

		if ( pMessageList != 0 )
		{
			Object = pMessageList->Next(0);

			if ( Object != 0 )
			{
				pMessageList->Remove(Object);
			}
		}
		else
		{
			Object = 0;
		}

		Thread->UnLock();

		if ( Object == 0 )
		{
			break;
		}

		DCMsg = (CDCMessage*) Object;

		switch ( DCMsg->m_eType )
		{
			case DC_MESSAGE_DM_INFO:
			{
				CDownloadManagerInfo * msg = (CDownloadManagerInfo*)Object;

				QApplication::postEvent( this, new DC_DownloadManagerEvent( EVENT_UPDATE_DM_STATUSBAR, msg ) );

				break;
			}

			case DC_MESSAGE_FM_INFO:
			{
				CFileManagerInfo * msg = (CFileManagerInfo*)Object;

				QApplication::postEvent( this, new DC_FileManagerEvent( EVENT_UPDATE_FM_STATUSBAR, msg ) );

				break;
			}

			case DC_MESSAGE_TRAFFIC:
			{
				DCMessageTraffic * msg = (DCMessageTraffic*)Object;

				QApplication::postEvent( this, new DC_TrafficInfoEvent( EVENT_UPDATE_TR_STATUSBAR, msg ) );

				break;
			}

			case DC_MESSAGE_SLOT_OBJECT:
			{
				MessageSlot( (CMessageDMSlotObject *)Object );
				break;
			}

			case DC_MESSAGE_LOG:
			{
				MessageLog( (CMessageLog*)Object );

				break;
			}

			case DC_MESSAGE_FILE_OBJECT:
			{
				CMessageDMFileObject * msg = (CMessageDMFileObject*)Object;

				// must be called BEFORE UpdateTransferWaitList
				UpdateLocalFileList( msg );

				if ( UpdateTransferWaitList( msg ) == TRUE )
				{
					bLVWaitUpdate = TRUE;
				}

				break;
			}

			case DC_MESSAGE_TRANSFER_OBJECT:
			{
				MessageTransfer( (CMessageDMTransferObject*)Object );

				break;
			}

			case DC_MESSAGE_FILELIST_OBJECT:
			{
				CMessageDMFileListObject * msg = (CMessageDMFileListObject*)Object;

				NewFileBrowser(msg->sNick.Data(),msg->sHubName.Data(),msg->sHubHost.Data(),msg->sLocalFile.Data());

				break;
			}

			default:
			{
				break;
			}
		}

		if ( Object )
		{
			delete Object;
		}
	}

	if ( bLVWaitUpdate == TRUE )
	{
		ListView_TRANSFERWAIT->setUpdatesEnabled(TRUE);
		ListView_TRANSFERWAIT->triggerUpdate();
	}

	Timer->start( TIMER_BASE, TRUE );
}

/** */
void DCTransferView::MessageSlot( CMessageDMSlotObject * msg )
{
	QListViewItem * item = ListView_SLOTS->firstChild();

	while(item)
	{
		if ( (item->text(0) == msg->sNick.Data()) &&
		     (item->text(1) == msg->sHubName.Data()) )
		{
			if ( (msg->iSlots == 0) && (!msg->bPermanent) )
			{
				ListView_SLOTS->takeItem(item);
				delete item;
				item=0;
			}

			break;
		}

		item = item->nextSibling();
	}

	if ( (!item) && ((msg->iSlots > 0) || (msg->bPermanent)) )
	{
		item = new QListViewItem( ListView_SLOTS, msg->sNick.Data(), msg->sHubName.Data() );
	}

	if (item)
	{
		if ( msg->bPermanent )
		{
			item->setText(2,"X");
		}
		else
		{
			item->setText(2,QString().setNum(msg->iSlots));
		}
	}
}

/** */
void DCTransferView::MessageLog( CMessageLog * msg )
{
	bool bscroll;

	if ( m_pTextEdit_LOG->verticalScrollBar()->maxValue() == m_pTextEdit_LOG->verticalScrollBar()->value() )
	{
		bscroll = TRUE;
	}
	else
	{
		bscroll = FALSE;
	}

	if ( m_pTextEdit_LOG->paragraphs() > 300 )
	{
		m_pTextEdit_LOG->removeParagraph(0);
		m_pTextEdit_LOG->removeParagraph(0);
		m_pTextEdit_LOG->removeParagraph(0);
		m_pTextEdit_LOG->removeParagraph(0);
		m_pTextEdit_LOG->removeParagraph(0);
	}

	m_pTextEdit_LOG->append( QTime::currentTime().toString("[hh:mm:ss] ") + msg->sMessage.Data());

	if ( bscroll )
	{
		m_pTextEdit_LOG->scrollToBottom();
		m_pTextEdit_LOG->moveCursor( QTextEdit::MoveEnd, FALSE );
	}
}

/** */
void DCTransferView::MessageTransfer( CMessageDMTransferObject * msg )
{
	CMessageDMTransferObject * msg1 = 0;
				
	CString s;
	QString n;
	DCTransferListItem * TransferListItem = 0;

	pViewTransferList->Lock();

	if ( pViewTransferList->Get( CString().setNum(msg->m_nTransferID), (CObject*&)TransferListItem ) != 0 )
	{
		if ( msg->bRemoveTransfer == FALSE )
		{
			// create new entry
			TransferListItem = new DCTransferListItem();
			TransferListItem->pItem = new DC_QProgressListItem( ListView_TRANSFER, "", 2 );

			if ( msg->m_bEncrypted )
//				TransferListItem->pItem->setPixmap(0,QPixmap(ssl_no_xpm));
//			else
				TransferListItem->pItem->setPixmap(0,g_pIconLoader->GetPixmap(eiSSL_YES));

			if ( !g_pConfig->GetTransferViewOptions(etvoFILEPERCENT) )
			{
				TransferListItem->pItem->SetProgressEnable(FALSE);
			}
			
			TransferListItem->pObject = new CMessageDMTransferObject();
						
			msg1 = (CMessageDMTransferObject *)TransferListItem->pObject;
			// set transfer id
			msg1->m_nTransferID = msg->m_nTransferID;

			pViewTransferList->Add( CString().setNum(msg->m_nTransferID), TransferListItem );
		}
		else
		{
			pViewTransferList->UnLock();
			return;
		}
	}
	else if ( msg->bRemoveTransfer == TRUE )
	{
		ListView_TRANSFER->takeItem(TransferListItem->pItem);
		delete TransferListItem->pItem;
		delete TransferListItem->pObject;
		pViewTransferList->Del(CString().setNum(msg->m_nTransferID));
		pViewTransferList->UnLock();
		return;
	}

	msg1 = (CMessageDMTransferObject *)TransferListItem->pObject;

	//
	if ( msg1->m_bEncrypted != msg->m_bEncrypted )
	{
		msg1->m_bEncrypted = msg->m_bEncrypted;

		if ( msg->m_bEncrypted )
//			TransferListItem->pItem->setPixmap(0,QPixmap(ssl_no_xpm));
//		else
			TransferListItem->pItem->setPixmap(0,g_pIconLoader->GetPixmap(eiSSL_YES));
	}

	// update transfer state
	if ( msg1->eState != msg->eState )
	{
		msg1->eState = msg->eState;
		
		switch(msg1->eState)
		{
			case estTRANSFERDOWNLOAD:
				TransferListItem->pItem->setPixmap(2,g_pIconLoader->GetPixmap(eiDOWN));
				//TransferListItem->pItem->setText(3,tr("Download"));
				break;
			case estTRANSFERUPLOAD:
				TransferListItem->pItem->setPixmap(2,g_pIconLoader->GetPixmap(eiUP));
				//TransferListItem->pItem->setText(3,tr("Upload"));
				break;
			case estTRANSFERHANDSHAKE:
				TransferListItem->pItem->setPixmap(2,g_pIconLoader->GetPixmap(eiBACK));
				//TransferListItem->pItem->setText(3,tr("Handshake"));
				break;
			case estNONE:
				//TransferListItem->pItem->setText(3,tr("Nothing"));
				break;
			default:
				TransferListItem->pItem->setPixmap(2,g_pIconLoader->GetPixmap(eiHELP));
				//TransferListItem->pItem->setText(3,tr("Unknown"));
				break;
		}
	}

	// update nick
	if ( msg1->m_sDstNick != msg->m_sDstNick )
	{
		msg1->m_sDstNick = msg->m_sDstNick;
		//TransferListItem->pItem->setText( 0, msg->m_sDstNick.Data() );
		if ( msg1->sHost != msg->sHost )
			msg1->sHost    = msg->sHost;

		n  = msg1->m_sDstNick.Data();
		n += " (";
		n += msg1->sHost.Data();
		n += ")";

		TransferListItem->pItem->setText(0, n );
	}
	// update user host
	else if ( msg1->sHost != msg->sHost )
	{
		msg1->sHost    = msg->sHost;
		
		n  = msg1->m_sDstNick.Data();
		n += " (";
		n += msg1->sHost.Data();
		n += ")";

		TransferListItem->pItem->setText(0, n );
	}

	// update hub
	if ( msg1->sHubName != msg->sHubName )
	{
		msg1->sHubName = msg->sHubName;

		TransferListItem->pItem->setText(1, msg1->sHubName.Data() );
	}

	// update hubhost
	if ( msg1->m_sHubHost != msg->m_sHubHost )
	{
		msg1->m_sHubHost = msg->m_sHubHost;
	}
				
	// update filename
	if ( msg1->m_sSrcFile != msg->m_sSrcFile )
	{
		TransferListItem->pItem->resetProgress();
		QString meh = msg->m_sSrcFile.Data();
		if ( meh.contains( '\\', FALSE ) > 0 )
			meh = meh.mid( meh.findRev( '\\' )+1, meh.length() );
		else if ( meh.contains( '/', FALSE ) > 0 )
			meh = meh.mid( meh.findRev( '/' )+1, meh.length() );
		TransferListItem->pItem->setText( 3, meh );
	}

	// update remote filename + path
	if ( msg1->m_sDstFile != msg->m_sDstFile )
	{
		msg1->m_sDstFile = msg->m_sDstFile;
		TransferListItem->pItem->resetProgress();
		TransferListItem->pItem->setText( 4, msg->m_sDstFile.Data() );
	}

	// update local filename
	if ( msg1->m_sSrcFile != msg->m_sSrcFile )
	{
		msg1->m_sSrcFile = msg->m_sSrcFile;
		TransferListItem->pItem->resetProgress();
		TransferListItem->pItem->setText( 5, msg->m_sSrcFile.Data() );
	}

	// update transfer rate
	if ( (msg1->lRate != msg->lRate) ||
	     (msg1->m_nMultiRate != msg->m_nMultiRate) ||
	     (msg1->lSize != msg->lSize) ||
	     (msg1->lSizeDone != msg->lSizeDone) ||
	     (msg1->lStartPosition != msg->lStartPosition) ||
	     (msg1->lTransfered != msg->lTransfered) ||
	     (msg1->lEndPosition != msg->lEndPosition) )
	{
		msg1->lRate = msg->lRate;
		msg1->m_nMultiRate = msg->m_nMultiRate;
		msg1->lSize = msg->lSize;
		msg1->lSizeDone = msg->lSizeDone;
		msg1->lStartPosition = msg->lStartPosition;
		msg1->lTransfered = msg->lTransfered;
		msg1->lEndPosition = msg->lEndPosition;
		
		s = "";

		if ( g_pConfig->GetTransferViewOptions(etvoCHUNKPERCENT) )
		{
			if ( (msg1->lEndPosition-msg1->lStartPosition) != 0 )
			{
				s += CString().setNum(((msg1->lTransfered)*100)/(msg1->lEndPosition-msg1->lStartPosition));
				s += "% ";
			}
			else
			{
				s += "0% ";
			}
		}

		if ( g_pConfig->GetTransferViewOptions(etvoFILEPERCENT) )
		{
			TransferListItem->pItem->SetProgressEnable(TRUE);
			if ( msg1->lSize != 0 )
			{
				TransferListItem->pItem->setProgress( (msg1->lSizeDone*100)/msg1->lSize );
			}
			else
			{
				TransferListItem->pItem->setProgress( 0 );
			}

/*			if ( msg1->lSize != 0 )
			{
				s += CString().setNum(((msg1->lSizeDone)*100)/msg1->lSize);
				s += "% ";
			}
			else
			{
					s += "0% ";
			}
*/
		}
		else
		{
			TransferListItem->pItem->SetProgressEnable(FALSE);
		}
		
		if ( g_pConfig->GetTransferViewOptions(etvoCHUNKSIZE) )
		{
			s += " ";
			// s += CString().setNum(msg->lStartPosition);
			s += CUtils::GetSizeString(msg->lStartPosition,g_pConfig->GetUnit()).Data();
			s += "/";
			// s += CString().setNum(msg->lStartPosition+msg->lTransfered);
			s += CUtils::GetSizeString(msg->lStartPosition+msg->lTransfered,g_pConfig->GetUnit());
			s += "/";
			// s += CString().setNum(msg->lEndPosition);
			s += CUtils::GetSizeString(msg->lEndPosition,g_pConfig->GetUnit()).Data();
		}

		if ( g_pConfig->GetTransferViewOptions(etvoFILESIZE) )
		{
			s += " ";
			// s += CString().setNum(msg->lSizeDone);
			s += CUtils::GetSizeString(msg->lSizeDone,g_pConfig->GetUnit()).Data();
			s += "/";
			// s += CString().setNum(msg->lSize);
			s += CUtils::GetSizeString(msg->lSize,g_pConfig->GetUnit()).Data();
		}

		if ( g_pConfig->GetTransferViewOptions(etvoDOWNLOADRATESINGLE) )
		{
			ulonglong rate;

			rate = msg->lRate;

			s += " [";
			s += CUtils::GetTransferString(rate);
			s += "]";
		}

		if ( g_pConfig->GetTransferViewOptions(etvoELAPSEDTIMESINGLE) )
		{
			ulonglong rate = 0;

			rate = msg1->lSize-msg1->lSizeDone;

			if ( msg->lRate>0 )
				rate/=msg->lRate;

			s += " [";
			s += CUtils::GetTimeString(rate);
			s += "]";
		}

		if ( g_pConfig->GetTransferViewOptions(etvoDOWNLOADRATEMULTI) )
		{
			ulonglong rate;

			if ( (msg1->m_nMultiRate == 0) && (msg1->lRate != 0) )
				rate = msg1->lRate;
			else
				rate = msg1->m_nMultiRate;
						
			s += " [";
			s += CUtils::GetTransferString(rate);
			s += "]";
		}

		if ( g_pConfig->GetTransferViewOptions(etvoELAPSEDTIMEMULTI) )
		{
			ulonglong rate,r;

			rate = msg1->lSize-msg1->lSizeDone;

			if ( (msg1->m_nMultiRate == 0) && (msg1->lRate != 0) )
				r=msg1->lRate;
			else
				r=msg1->m_nMultiRate;
			
			if ( r>0 )
				rate/=r;

			s += " [";
			s += CUtils::GetTimeString(rate);
			s += "]";
		}

		TransferListItem->pItem->setText(2,s.Data());
	}

	pViewTransferList->UnLock();
}

/** */
bool DCTransferView::UpdateTransferWaitList( CMessageDMFileObject * msg )
{
	CStringList * StringList1=0, *StringList2=0;
	DCTransferQueueItem * TransferQueueItem1=0,* TransferQueueItem2=0;
	CString sLocalFileName;
	QString s;
	bool bLVWaitUpdate = FALSE;

	pQueueList->Lock();

	// get the list for the nick
	if ( pQueueList->Get( msg->m_sNick, (CObject *&) StringList1) != 0 )
	{
		// not found
		if ( msg->m_bRemoveFile == TRUE )
		{
			// abort
			pQueueList->UnLock();
			return bLVWaitUpdate;
		}
		else
		{
			// create new list for this nick
			StringList1 = new CStringList();
			pQueueList->Add( msg->m_sNick, StringList1 );
		}
	}

	// get the list for the hub
	if ( StringList1->Get( msg->m_sHubName, (CObject *&) TransferQueueItem1 ) != 0 )
	{
		// create new list
		ListView_TRANSFERWAIT->setUpdatesEnabled(FALSE);
		bLVWaitUpdate = TRUE;

		TransferQueueItem1 = new DCTransferQueueItem();
		TransferQueueItem1->pObject = new CStringList();
		TransferQueueItem1->pItem   = new QListViewItem( ListView_TRANSFERWAIT, msg->m_sNick.Data() );
		TransferQueueItem1->pItem->setText(1,msg->m_sHubName.Data());
		TransferQueueItem1->pItem->setText(2,msg->m_sHubHost.Data());

		TransferQueueItem1->sHubName = msg->m_sHubName;
		TransferQueueItem1->sHubHost = msg->m_sHubHost;

		StringList1->Add( msg->m_sHubName, TransferQueueItem1 );
	}
	else
	{
		// update the view
		if ( TransferQueueItem1->sHubHost != msg->m_sHubHost )
		{
			ListView_TRANSFERWAIT->setUpdatesEnabled(FALSE);
			bLVWaitUpdate = TRUE;
			TransferQueueItem1->sHubHost = msg->m_sHubHost;
			TransferQueueItem1->pItem->setText(2,msg->m_sHubHost.Data());
		}
	}

	// get the list with the files
	StringList2 = (CStringList*)TransferQueueItem1->pObject;

	TransferQueueItem2 = 0;

	// get the fileobject from the file list
	if ( msg->m_sRemoteFile != "" )
	{
		StringList2->Get( msg->m_sRemoteFile, (CObject *&) TransferQueueItem2 );
	}

	// check for remove this entry
	if ( msg->m_bRemoveFile == TRUE )
	{
		ListView_TRANSFERWAIT->setUpdatesEnabled(FALSE);
		bLVWaitUpdate = TRUE;

		// remove all files with the root
		if ( msg->m_sRemoteFile == "" )
		{
			// remove all items from the list and view
			TransferQueueItem2 = 0;

			while ( StringList2->Next( (CObject *&) TransferQueueItem2 ) )
			{
				TransferQueueItem1->pItem->takeItem(TransferQueueItem2->pItem);
				delete TransferQueueItem2->pItem;
				TransferQueueItem2->pItem = 0;
				delete (CMessageDMFileObject*)TransferQueueItem2->pObject;
				TransferQueueItem2->pObject = 0;
			}

			// clear the list
			StringList2->Clear();

			// remove the root
			ListView_TRANSFERWAIT->takeItem(TransferQueueItem1->pItem);
			delete TransferQueueItem1->pItem;
			TransferQueueItem1->pItem = 0;
			delete (CStringList*)TransferQueueItem1->pObject;
			TransferQueueItem1->pObject = 0;

			StringList1->Del( msg->m_sHubName );

			if ( StringList1->Count() == 0 )
			{
				pQueueList->Del( msg->m_sNick );
			}
		}
		// remove only the given file
		else
		{
			// remove the file
			if ( TransferQueueItem2 != 0 )
			{
				TransferQueueItem1->pItem->takeItem(TransferQueueItem2->pItem);
				delete TransferQueueItem2->pItem;
				TransferQueueItem2->pItem = 0;
				delete (CMessageDMFileObject*)TransferQueueItem2->pObject;
				StringList2->Remove( msg->m_sRemoteFile );
				delete TransferQueueItem2;
				TransferQueueItem2 = 0;
			}

			// remove empty list ...
			if ( StringList2->Count() == 0 )
			{
				ListView_TRANSFERWAIT->takeItem(TransferQueueItem1->pItem);
				delete TransferQueueItem1->pItem;
				TransferQueueItem1->pItem = 0;
				delete (CStringList*)TransferQueueItem1->pObject;
				TransferQueueItem1->pObject = 0;
				StringList1->Del( msg->m_sHubName );

				if ( StringList1->Count() == 0 )
				{
					pQueueList->Del( msg->m_sNick );
				}
			}
		}
	}
	// update the entry
	else
	{
		// set the user state
		switch(msg->m_eTransferWaitState)
		{
			case etwsWAIT:
				s = tr("Wait");
				break;
			case etwsIDLE:
				s = tr("Idle");
				break;
			case etwsRUN:
				s = tr("Run");
				s += " ["+QString().setNum(msg->m_nConnections)+"]";
				break;
			case etwsHUBOFFLINE:
				s = tr("Hub offline");
				break;
			case etwsUSEROFFLINE:
				s = tr("User offline");
				break;
			case etwsUSERBUSY:
				s = tr("User busy");
				break;
			case etwsSENDERROR:
				s = tr("Send error");
				break;
			default:
				s = tr("Unknown");
				break;
		}

		TransferQueueItem1->pItem->setText(3,s);

		if ( msg->m_sRemoteFile != "" )
		{
			// create a entry for this file
			if ( TransferQueueItem2 == 0 )
			{
				ListView_TRANSFERWAIT->setUpdatesEnabled(FALSE);
				bLVWaitUpdate = TRUE;

				TransferQueueItem2 = new DCTransferQueueItem();
			
				// clear object pointer
				TransferQueueItem2->pObject = new CMessageDMFileObject();
				*(CMessageDMFileObject*)TransferQueueItem2->pObject = *msg;
				TransferQueueItem2->pItem   = new QListViewItem ( TransferQueueItem1->pItem, "" );
				TransferQueueItem2->pItem->setText(1, msg->m_sRemoteFile.Data());
				TransferQueueItem2->pItem->setText(2, CString().setNum(msg->m_nSize).Data());

				StringList2->Add( msg->m_sRemoteFile, TransferQueueItem2 );
			}

			// update the file state
			switch(msg->m_eTransferFileState)
			{
				case etfsNONE:
					s = tr("Idle");
					break;
				case etfsTRANSFER:
					s = tr("Transfer");
					break;
				case etfsERROR:
					s = tr("Error");
					break;
				case etfsPAUSE:
					s = tr("Pause");
					break;
				default:
					s = tr("Unknown");
					break;
			}

			if ( msg->m_bMulti == TRUE )
			{
				s = "*"+s;
			}

			s += "/"+QString().setNum(msg->m_nPriority);

			TransferQueueItem2->pItem->setText(3,s);
		}
	}

	pQueueList->UnLock();

	return bLVWaitUpdate;
}

/** */
bool DCTransferView::UpdateLocalFileList( CMessageDMFileObject * msg )
{
	CStringList * StringList1=0, *StringList2=0;
	DCTransferQueueItem * TransferQueueItem1=0,* TransferQueueItem2=0;
	QString s;
	bool bLVWaitUpdate = FALSE;
	CString hnindex="";

	pQueueLocalList->Lock();

	if ( msg->m_sLocalFile == "" )
	{
		if  ( msg->m_bRemoveFile == FALSE )
		{
			// abort
			pQueueLocalList->UnLock();
			return bLVWaitUpdate;
		}
		else
		{
			// This is a bad case : when removing all downloads corresponding to a nick

			// get the list for the nick
			if ( pQueueList->Get( msg->m_sNick, (CObject *&) StringList1) != 0 )
			{
				printf("Nick not found while updating LocalFileList\n");
				pQueueLocalList->UnLock();
				return bLVWaitUpdate;
			}

			// get the list for the hub
			if ( StringList1->Get( msg->m_sHubName, (CObject *&) TransferQueueItem1 ) != 0 )
			{
				printf("Hub not found while updating LocalFileList\n");
				pQueueLocalList->UnLock();
				return bLVWaitUpdate;
			}

			// get the list with the files
			StringList2 = (CStringList*)TransferQueueItem1->pObject;

			// remove all items from the list
			TransferQueueItem2 = 0;
			while ( StringList2->Next( (CObject *&) TransferQueueItem2 ) )
			{
				DCTransferQueueItem * TransferQueueItem3=0, * TransferQueueItem4=0;
				CMessageDMFileObject * msg2;

				msg2 = (CMessageDMFileObject *) (TransferQueueItem2->pObject);
				hnindex = msg2->m_sHubName + "|" + msg2->m_sNick;

				if ( pQueueLocalList->Get( msg2->m_sLocalFile, (CObject *&) TransferQueueItem3) == 0 )
				{
					StringList1 = (CStringList*)TransferQueueItem3->pObject;
					if ( StringList1->Get( hnindex, (CObject *&) TransferQueueItem4 ) == 0 )
					{
						bLVWaitUpdate = TRUE;
						TransferQueueItem3->pItem->takeItem(TransferQueueItem4->pItem);
						delete TransferQueueItem4->pItem;
						StringList1->Del(hnindex);

						if ( StringList1->Count() == 0 )
						{
							ListView_LOCALFILES->takeItem(TransferQueueItem3->pItem);
							delete TransferQueueItem3->pItem;
							delete StringList1;
							pQueueLocalList->Del(msg2->m_sLocalFile);
						}
					}
				}
			}
			pQueueLocalList->UnLock();
			return bLVWaitUpdate;
		}
	}

	if ( pQueueLocalList->Get( msg->m_sLocalFile, (CObject *&) TransferQueueItem1) != 0 )
	{
		// not found
		if ( msg->m_bRemoveFile == TRUE )
		{
			// abort
			pQueueLocalList->UnLock();
			return bLVWaitUpdate;
		}
		else
		{
			QString size_h;
			DCFileTool FileTool;

			// create new list for this nick
			TransferQueueItem1 = new DCTransferQueueItem();
			StringList1 = new CStringList();
			TransferQueueItem1->pObject = StringList1;

			size_h = QString(CString().setNum(msg->m_nSize).Data());
			size_h += " (";
			size_h.append(CUtils::GetSizeString(msg->m_nSize,g_pConfig->GetUnit()).Data());
			size_h += ")";

			TransferQueueItem1->pItem = new DC_QListViewItem( ListView_LOCALFILES );
			((DC_QListViewItem*)TransferQueueItem1->pItem)->mycol   = 1;
			((DC_QListViewItem*)TransferQueueItem1->pItem)->myvalue = msg->m_nSize;
			TransferQueueItem1->pItem->setText(0,msg->m_sLocalFile.Data());
			TransferQueueItem1->pItem->setText(1,size_h);

			pQueueLocalList->Add( msg->m_sLocalFile, TransferQueueItem1 );
		}
	}

	StringList1 = (CStringList*)TransferQueueItem1->pObject;

	hnindex = msg->m_sHubName + "|" + msg->m_sNick;

	// check for remove this entry
	if ( msg->m_bRemoveFile == TRUE )
	{
		if ( StringList1->Get( hnindex, (CObject *&) TransferQueueItem2 ) == 0 )
		{
			TransferQueueItem1->pItem->takeItem(TransferQueueItem2->pItem);
			delete TransferQueueItem2->pItem;
			StringList1->Del(hnindex);

			if ( StringList1->Count() == 0 )
			{
				ListView_LOCALFILES->takeItem(TransferQueueItem1->pItem);
				delete TransferQueueItem1->pItem;
				delete StringList1;
				pQueueLocalList->Del(msg->m_sLocalFile);
			}
		}
	}
	else
	{
		if ( StringList1->Get( hnindex, (CObject *&) TransferQueueItem2 ) != 0 )
		{
			TransferQueueItem2 = new DCTransferQueueItem();

			TransferQueueItem2->pItem = new DC_QListViewItem( TransferQueueItem1->pItem );
			TransferQueueItem2->pItem->setText(0,msg->m_sNick.Data());
			TransferQueueItem2->pItem->setText(1,msg->m_sHubName.Data());
			TransferQueueItem2->pItem->setText(2,msg->m_sRemoteFile.Data());
			// set the user state
			switch(msg->m_eTransferWaitState)
			{
				case etwsWAIT:
					s = tr("Wait");
					break;
				case etwsIDLE:
					s = tr("Idle");
					break;
				case etwsRUN:
					s = tr("Run");
					s += " ["+QString().setNum(msg->m_nConnections)+"]";
					break;
				case etwsHUBOFFLINE:
					s = tr("Hub offline");
					break;
				case etwsUSEROFFLINE:
					s = tr("User offline");
					break;
				case etwsUSERBUSY:
					s = tr("User busy");
					break;
				case etwsSENDERROR:
					s = tr("Send error");
					break;
				default:
					s = tr("Unknown");
					break;
			}

			TransferQueueItem2->pItem->setText(3,s);

			StringList1->Add( hnindex, TransferQueueItem2 );
		}
	}

	pQueueLocalList->UnLock();

	return TRUE;
}

/** */
void DCTransferView::NewFileBrowser( QString nick, QString hubname, QString hubhost, QString share )
{
	DCFileBrowser *bft;
	bft = new DCFileBrowser( pWorkspace, "Filebrowser", WDestructiveClose );

	// set transfer
	bft->installEventFilter(this);
	bft->LoadFileList(share);
	pFileList->Add(bft);
	bft->show();
}

bool DCTransferView::IsUserInQueue( QString Nick, QString Hubname )
{
	CStringList * StringList1=0;
	DCTransferQueueItem * TransferQueueItem1=0;

	pQueueList->Lock();

	// get the list corresponding to the nick
	if ( pQueueList->Get( Nick.ascii(), (CObject *&) StringList1) != 0 )
	{
		pQueueList->UnLock();
		return FALSE;
	}

	// search for the corresponding hub
	if ( StringList1->Get( Hubname.ascii(), (CObject *&) TransferQueueItem1 ) != 0 )
	{
		pQueueList->UnLock();
		return FALSE;
	}

	pQueueList->UnLock();
	return TRUE;
}

/** */
void DCTransferView::GetLocalFilesList( QStringVector & LocalFiles, ulonglong size )
{
	QListViewItem * LocalFileItem=0;

	LocalFiles.clear();

	LocalFileItem = ListView_LOCALFILES->firstChild();

	while( LocalFileItem )
	{
		if ( LocalFileItem->text(1) != "0" ) // size
		{
			if (( size == 0 ) || ( ((DC_QListViewItem*)LocalFileItem)->myvalue == size ))
			{
				LocalFiles.push_back( LocalFileItem->text(0) );
			}
		}
		LocalFileItem = LocalFileItem->nextSibling();
	}

	/*
	// Alternative method:
	// Trying not to use QListViewItem should be faster
	CString localfile;
	CStringList * StringList1=0;
	DCTransferQueueItem * TransferQueueItem;

	pQueueLocalList->Lock();

	while ( pQueueLocalList->Next( localfile, (CObject *&) TransferQueueItem) != 0 )
	{
		printf("\nLocalFile: %s\n\n", localfile.Data());
		StringList1 = (CStringList*) TransferQueueItem->pObject;
		TransferQueueItem = 0;
		if ( StringList1->Next( (CObject *&) TransferQueueItem) != 0 )
		{
			int localsize=???;
			if ( localsize != 0 )
			{
				printf("\nSize: %lu\n\n", localsize);
				if (( size == 0 ) || ( localsize == size ))
				{
					QString Qlocalfile( localfile.Data() );
					if ( Qlocalfile.contains('\\') )
						Qlocalfile = Qlocalfile.section('\\',-1);
					else
						Qlocalfile = Qlocalfile.section('/',-1);
					LocalFiles.push_back( Qlocalfile );
				}
			}
		}
	}

	pQueueLocalList->UnLock();
	*/
}

/** */
ulonglong DCTransferView::FindTransferID( QListViewItem * item )
{
	CMessageDMTransferObject * msg;
	DCTransferListItem * TransferListItem = 0;
	ulonglong id = 0;

	pViewTransferList->Lock();

	while ( pViewTransferList->Next( (CObject*&)TransferListItem ) )
	{
		msg = (CMessageDMTransferObject *) TransferListItem->pObject;

		if ( TransferListItem->pItem == item )
		{
			id = msg->m_nTransferID;
			break;
		}
	}

	pViewTransferList->UnLock();

	return id;
}

/** */
bool DCTransferView::GetTransferMessageObject( QListViewItem * item, CMessageDMTransferObject * obj )
{
	bool res = FALSE;
	
	CMessageDMTransferObject * msg;
	DCTransferListItem * TransferListItem = 0;

	pViewTransferList->Lock();

	while ( pViewTransferList->Next( (CObject*&)TransferListItem ) )
	{
		msg = (CMessageDMTransferObject *) TransferListItem->pObject;

		if ( TransferListItem->pItem == item )
		{
			*obj = *msg;
			res = TRUE;
			break;
		}
	}

	pViewTransferList->UnLock();

	return res;
}

/** */
eConnectionState DCTransferView::GetTransferDirection( ulonglong sid )
{
	CMessageDMTransferObject * msg;
	DCTransferListItem * TransferListItem = 0;
	eConnectionState state = estNONE;

	pViewTransferList->Lock();

	if ( pViewTransferList->Get( CString().setNum(sid), (CObject*&)TransferListItem ) == 0 )
	{
		msg = (CMessageDMTransferObject *) TransferListItem->pObject;
		if ( msg )
			state = msg->eState;
	}

	pViewTransferList->UnLock();

	return state;
}

/** */
void DCTransferView::ConnectToAllHubs()
{
	CStringList * StringList1=0;
	DCTransferQueueItem * TransferQueueItem1=0;

	pQueueList->Lock();

	while ( pQueueList->Next( (CObject *&) StringList1) )
	{
		TransferQueueItem1 = 0;

		while ( StringList1->Next( (CObject *&) TransferQueueItem1 ) )
		{
			g_pConnectionManager->Connect( TransferQueueItem1->sHubName.Data(), TransferQueueItem1->sHubHost.Data() );
		}
	}

	pQueueList->UnLock();
}

/** */
void DCTransferView::SearchFileClone(QString filename, ulonglong size)
{
	QString searchtxt;
	QRegExp re_ext;

	// convert local file name into a suitable search expression
	if ( filename.contains('\\') )
		searchtxt = filename.section('\\',-1);
	else
		searchtxt = filename.section('/',-1);
	searchtxt.replace(QRegExp("_")," ");
	searchtxt.replace(QRegExp("-")," ");
	re_ext = QRegExp("\\.(\\w{3,4})$");
	re_ext.search( searchtxt );
	searchtxt.replace( re_ext, " "+re_ext.cap(1) );
	re_ext = QRegExp(",");
	while (searchtxt.contains(re_ext))
	    searchtxt.replace(re_ext," ");
	re_ext = QRegExp("\\s(a|the|and|or|in|to|of)\\s");
	re_ext.setCaseSensitive(false);
	while (searchtxt.contains(re_ext))
	    searchtxt.replace(re_ext," ");
	re_ext = QRegExp("^(the|a)\\s");
	re_ext.setCaseSensitive(false);
	while (searchtxt.contains(re_ext))
	    searchtxt.replace(re_ext,"");
	re_ext = QRegExp("\\s{2,}");
	while (searchtxt.contains(re_ext))
	    searchtxt.replace(re_ext," ");

	g_pHubSearch->Combobox_SEARCH->insertItem(searchtxt,0);
	g_pHubSearch->Combobox_SEARCH->setCurrentItem(0);
	g_pHubSearch->LineEdit_SEARCHSIZE->setText(CString().setNum(size).Data());
	g_pHubSearch->ComboBox_SEARCHTYPE->setCurrentItem(0);
	g_pHubSearch->ComboBox_SEARCHUNIT->setCurrentItem(0);
	g_pHubSearch->ComboBox_SEARCHLIMIT->setCurrentItem(2);

	if ( g_pHubSearch->isMinimized() )
	{
		g_pHubSearch->showNormal();
	}
	else if ( g_pHubSearch->isVisible()==FALSE )
	{
		g_pHubSearch->setEnabled(TRUE);
		g_pHubSearch->show();
	}

	if ( g_pHubSearch->TabWidget_HUBSEARCH->isVisible()==FALSE )
	{
		g_pHubSearch->TabWidget_HUBSEARCH->show();
	}
}

/** */
void DCTransferView::EditExistingTransfer(QString & nick, QString & hubname, QString & hubhost, CList<DCHubObject> * list )
{
	DCEditTransfer * dialg;

	dialg = new DCEditTransfer();

	dialg->Init(nick,hubname,hubhost,list);

	if ( dialg->exec() == QDialog::Accepted )
	{
		CString OldNick;
		CString OldHubname;

		OldNick = nick.ascii();
		OldHubname = hubname.ascii();

		nick	= dialg->LineEdit_NICK->text();
		hubname	= dialg->LineEdit_HUBNAME->text();
		hubhost	= dialg->LineEdit_HUBHOST->text();

		DLM_QueueEdit( OldNick, OldHubname, nick.ascii(), hubname.ascii(), hubhost.ascii());
	}

	delete dialg;
}

/** */
int DCTransferView::selectedItems( QListView * list, QPtrList<QListViewItem> & lst )
{
	QListViewItemIterator it( (QListView *)list );

	for ( ; it.current(); it++ )
	{
		if ( it.current()->isSelected() )
		{
			lst.append(it.current());
		}
	}

	return lst.count();
}

/** */
void DCTransferView::slotRightButtonClickedTransferList( QListViewItem * item , const QPoint &, int )
{
	int id;
	QPopupMenu *m;
	CMessageDMTransferObject transfermsg;
	
	if( item == 0 )
	{
		return;
	}

	if ( GetTransferMessageObject(item,&transfermsg) == FALSE )
	{
		return;
	}

	m = new QPopupMenu(this);

	DCMenuHandler::InsertMenu( m, emiPRIVATE_CHAT, (transfermsg.m_sDstNick!="") );
	DCMenuHandler::InsertMenu( m, emiBROWSE_USER_FILES, (transfermsg.m_sDstNick!="") ); // ,(UserFileInfo.sUserFileList != "") );
	DCMenuHandler::InsertMenu( m, emiSEPARATOR );
	DCMenuHandler::InsertMenu( m, emiCLOSE_TRANSFER );
	DCMenuHandler::InsertMenu( m, emiCHANGE_TRANSFER_RATE, (GetTransferDirection(transfermsg.m_nTransferID) == estTRANSFERUPLOAD) && (g_pConfig->GetDynamicUploadRate() == FALSE));

	id = m->exec(QCursor::pos());

	delete m;

	if ( id == emiPRIVATE_CHAT )
        {
                // open chat with user
                g_pConnectionManager->OpenPrivateChat( transfermsg.sHubName.Data(), transfermsg.m_sHubHost.Data(), transfermsg.m_sDstNick.Data() );
        }
        else if ( id == emiBROWSE_USER_FILES )
        {
		// TODO: check if hub online ...

                // add transfer to the waitlist
                g_pTransferView->DLM_QueueAdd( transfermsg.m_sDstNick, transfermsg.sHubName,
                                                transfermsg.m_sHubHost,
                                                DC_USER_FILELIST_HE3, DC_USER_FILELIST_HE3, "", "", eltBUFFER,
                                                0, 0 );
        }
	else if ( id == emiCLOSE_TRANSFER )
	{
		if ( DLM_TransferClose( transfermsg.m_nTransferID ) == FALSE )
		{
			// TODO: error message
		}
	}
	else if ( id == emiCHANGE_TRANSFER_RATE )
	{
		bool ok = FALSE;
		ulonglong rate;

		if ( DLM_TransferGetRate( transfermsg.m_nTransferID, rate ) == FALSE )
		{
			// TODO: error message
		}
		else
		{
			rate = QInputDialog::getInteger(
				tr("Change Transfer-Rate"),
				tr("Please enter a Transfer-Rate [B/s] (0=off)"), rate, 0, 9999999, 512, &ok, this );
		}

		if ( ok )
		{
			if ( (rate < 512) && (rate != 0) )
			{
				rate = 512;
			}

			if ( DLM_TransferSetRate( transfermsg.m_nTransferID, rate ) == FALSE )
			{
				// TODO: error message
			}
		}
	}
}

/** */
void DCTransferView::slotRightButtonClickedTransferWaitList( QListViewItem * /*item*/ , const QPoint &, int )
{
        int id;
        QPopupMenu *m;
        QListViewItem * item1;
        QString nick,hubname,hubhost,file;
        CUserFileInfo UserFileInfo;
        QPtrList<QListViewItem> selitems;
        QListViewItem * curitem;
        bool inactiveTransfer = TRUE, b;
	int numSelected;

	numSelected = selectedItems( ListView_TRANSFERWAIT, selitems );

	if ( numSelected == 0 )
	{
		return;
	}

	for ( curitem = selitems.first(); curitem; curitem = selitems.next() )
        {
                if ( curitem->depth() == 1 )
                {
                        item1 = curitem->parent();
                }
                else
                {
                        item1 = curitem;
                }

                if ( item1 == 0 )
                {
                        return;
                }

                nick    = item1->text(0);
                hubname = item1->text(1);
                hubhost = item1->text(2);

		if ( item1 != curitem )
		{
			file = curitem->text(1);
		}
		else
		{
			file = "";
		}

		if ( DLM_QueueGetFileInfo(nick.ascii(),hubname.ascii(),hubhost.ascii(),file.ascii(),&UserFileInfo) == FALSE )
		{
			return;
		}

		inactiveTransfer = inactiveTransfer && ( ((UserFileInfo.eWaitState != etwsRUN) && (UserFileInfo.eWaitState != etwsWAIT)) ||
					( (file != "") && (UserFileInfo.eFileState!=etfsTRANSFER)));
        }

        if ( numSelected != 1 )
        {
		nick = hubname = hubhost = "";
        }

	m = new QPopupMenu(this);

	DCMenuHandler::InsertMenu( m, emiPAUSE_TRANSFER_QUEUE );
	DCMenuHandler::InsertMenu( m, emiRESUME_TRANSFER_QUEUE );
	DCMenuHandler::InsertMenu( m, emiREMOVE_TRANSFER_QUEUE, inactiveTransfer );
	//DCMenuHandler::InsertMenu( m, emiREMOVE_TRANSFER_QUEUE_DISK, (inactiveTransfer && FALSE) ); //(TransferItem.eState == etwsIDLE) );
	DCMenuHandler::InsertMenu( m, emiSEPARATOR );
	DCMenuHandler::InsertMenu( m, emiTRY_CONNECT, (inactiveTransfer) );
	DCMenuHandler::InsertMenu( m, emiCONNECT_TO_HUB );
	DCMenuHandler::InsertMenu( m, emiCONNECT_TO_ALL_HUBS );
	DCMenuHandler::InsertMenu( m, emiBROWSE_USER_FILES, (numSelected==1) );
	DCMenuHandler::InsertMenu( m, emiSEPARATOR );
	DCMenuHandler::InsertMenu( m, emiFILE_INFO, ((UserFileInfo.sLocalFile != "") && (numSelected==1)) );
	DCMenuHandler::InsertMenu( m, emiSEPARATOR );
	DCMenuHandler::InsertMenu( m, emiEDIT_TRANSFER, ((selitems.first()->depth() == 0) && (inactiveTransfer) && (numSelected==1)) );
	DCMenuHandler::InsertMenu( m, emiEDIT_FILE_PRIORITY );
	DCMenuHandler::InsertMenu( m, emiUPDATE_SERVER);
	DCMenuHandler::InsertMenu( m, emiSAVE_QUEUE );

        id = m->exec(QCursor::pos());
        delete m;

        if ( id == emiCONNECT_TO_HUB )
        {
                for ( curitem = selitems.first(); curitem; curitem = selitems.next() )
                {
                        if ( curitem->depth() == 1 )
                        {
                                item1 = curitem->parent();
                        }
                        else
                        {
                                item1 = curitem;
                        }
                        hubname = item1->text(1);
                        hubhost	= item1->text(2);

			if ( g_pConnectionManager->IsHubOnline(hubname.ascii(),hubhost.ascii()) == ehsNONE )
			{
				g_pConnectionManager->Connect( hubname.ascii(), hubhost.ascii() );
			}
		}
        }
        else if ( id == emiCONNECT_TO_ALL_HUBS )
        {
                ConnectToAllHubs();
        }
        else if ( id == emiBROWSE_USER_FILES )
        {
                NewFileBrowser(nick,hubname,hubhost,UserFileInfo.sLocalFile.Data());
        }
        else if ( id == emiTRY_CONNECT )
        {
			for ( curitem = selitems.first(); curitem; curitem = selitems.next() ) {
				if ( curitem->depth() == 1 ) {
					item1 = curitem->parent();
				} else {
					item1 = curitem;
				}
				nick    = item1->text(0);
				hubname = item1->text(1);
                if ( DLM_TransferConnect( nick.ascii(), hubname.ascii() ) == FALSE ) {
					// error message
					QMessageBox::critical( 0, tr("Try Connect"),
						tr("User and Hub not found in the queue !") + "\n\n" +
						tr("Nick:") + " '" +
						nick + "'\n" +
						tr("Hub:") + " '" + hubname + "'\n" );
				}
			}
        }
	else if ( (id == emiPAUSE_TRANSFER_QUEUE) || (id == emiRESUME_TRANSFER_QUEUE) )
	{
		if ( id == emiPAUSE_TRANSFER_QUEUE )
		{
			b = TRUE;
		}
		else
		{
			b = FALSE;
		}

                for ( curitem = selitems.first(); curitem; curitem = selitems.next() )
                {
                        if ( curitem->depth() == 1 )
                        {
                                item1 = curitem->parent();
                        }
                        else
                        {
                                item1 = curitem;
                        }

                        nick    = item1->text(0);
                        hubname = item1->text(1);

                        if ( item1 != curitem )
                        {
                                file = curitem->text(1);
                        }
                        else
                        {
                                file = "";
                        }

                        if ( DLM_QueuePause( nick.ascii(), hubname.ascii(), file.ascii(), b ) == FALSE )
                        {
                                // TODO: error handling
                        }
                }
	}
        else if ( id == emiREMOVE_TRANSFER_QUEUE )
        {
		if (g_pConfig->GetQueryOnFileDelete()) {
			// first we ask the user
			switch( QMessageBox::warning( this, tr("Remove Transfer"),
				tr("You are sure ?"),
				tr("Remove"),
				tr("Cancel"), 0, 0, 1 ) )
			{
				case 1: // The user clicked the Quit or pressed Escape
					return;
				default:
					break;
			}
		}

                for ( curitem = selitems.first(); curitem; curitem = selitems.next() )
                {
                        if ( curitem->depth() == 1 )
                        {
                                item1 = curitem->parent();
                        }
                        else
                        {
                                item1 = curitem;
                        }

                        nick    = item1->text(0);
                        hubname = item1->text(1);

                        if ( item1 != curitem )
                        {
                                file = curitem->text(1);
                        }
                        else
                        {
                                file = "";
                        }

                        if ( DLM_QueueRemove(nick.ascii(),hubname.ascii(),file.ascii()) == FALSE )
                        {
                                // TODO: error handling
                        }
                }
        }
        else if ( id == emiFILE_INFO )
        {
		DCFileTransferInfo * ft;

		ft = new DCFileTransferInfo(UserFileInfo.sLocalFile);
		ft->exec();
		delete ft;
        }
        else if ( id == emiUPDATE_SERVER )
        {
                for ( curitem = selitems.first(); curitem; curitem = selitems.next() )
                {
                        if ( curitem->depth() == 1 )
                        {
                                item1 = curitem->parent();
                        }
                        else
                        {
                                item1 = curitem;
                        }

                        nick    = item1->text(0);
                        hubname = item1->text(1);

			if ( DLM_QueueUpdateHub( nick.ascii(), hubname.ascii() ) == FALSE )
			{
				// TODO: error message ...
			}
		}
        }
        else if ( id == emiEDIT_TRANSFER )
        {
		CList<DCHubObject> list;

		curitem = selitems.first();

                nick    = curitem->text(0);
                hubname = curitem->text(1);
                hubhost = curitem->text(2);

		DLM_QueueGetHub( nick.ascii(), hubname.ascii(), &list );

                EditExistingTransfer( nick, hubname, hubhost, &list );
        }
	else if ( id == emiEDIT_FILE_PRIORITY )
	{
		bool ok = FALSE;
		int priority=0;

		priority = QInputDialog::getInteger(
			tr("Change File-Priority"),
			tr("Please enter a priority"), priority, 0, MAX_FILE_PRIORITY, 1, &ok, this );

		if ( ok )
		{
	                for ( curitem = selitems.first(); curitem; curitem = selitems.next() )
        	        {
	                        if ( curitem->depth() == 0 )
        	                {
			                for ( item1 = curitem->firstChild(); item1; item1 = item1->nextSibling() )
        			        {
			                        nick    = curitem->text(0);
        			                hubname = curitem->text(1);
						file    = item1->text(1);

						if ( DLM_QueueSetFilePriority( nick.ascii(), hubname.ascii(), file.ascii(), priority ) == FALSE )
						{
							// TODO: error message ...
						}
					}
				}
	                        else if ( curitem->depth() == 1 )
        	                {
                	                item1 = curitem->parent();

		                        nick    = item1->text(0);
        		                hubname = item1->text(1);
					file    = curitem->text(1);

					if ( DLM_QueueSetFilePriority( nick.ascii(), hubname.ascii(), file.ascii(), priority ) == FALSE )
					{
						// TODO: error message ...
					}
				}
			}
		}
	}
        else if ( id == emiSAVE_QUEUE )
        {
                DLM_SaveQueue();
        }

	selitems.clear();
}


/** */
void DCTransferView::slotRightButtonClickedLocalFilesList( QListViewItem * item , const QPoint &, int )
{
	int id;
	QPopupMenu *m;
	QListViewItem * item1;
	QString localfile,nick,hubname,remotefile;
	ulonglong size;
	CUserFileInfo UserFileInfo;
	bool removetransfer = true;

	if( item == 0 )
	{
		return;
	}

	if ( item->depth() == 1 )
	{
		item1 = item->parent();
	}
	else
	{
		item1 = item;
	}

	if ( item1 == 0 )
	{
		return;
	}

	localfile = item1->text(0);
	size      = CString(item1->text(1).ascii()).asULL();

	if ( item->depth() == 1 )
	{
		nick       = item->text(0);
		hubname    = item->text(1);
		remotefile = item->text(2);

		if (DLM_QueueGetFileInfo(nick.ascii(),hubname.ascii(),"hubhost",remotefile.ascii(),&UserFileInfo) == false)
	        {
			return;
		}
		removetransfer = ((UserFileInfo.eWaitState != etwsRUN) && (UserFileInfo.eWaitState != etwsWAIT)) ||
                                   ( (remotefile != "") && (UserFileInfo.eFileState!=etfsTRANSFER));
	}
	else
	{
		QListViewItem * tmpitem;
		for(tmpitem=item->firstChild(); tmpitem; tmpitem=tmpitem->nextSibling())
                {
			nick       = tmpitem->text(0);
			hubname    = tmpitem->text(1);
			remotefile = tmpitem->text(2);
			if (DLM_QueueGetFileInfo(nick.ascii(),hubname.ascii(),"hubhost",remotefile.ascii(),&UserFileInfo) == false)
			{
				return;
			}
			removetransfer = removetransfer && ( ((UserFileInfo.eWaitState != etwsRUN) && (UserFileInfo.eWaitState != etwsWAIT)) ||
							     ( (remotefile != "") && (UserFileInfo.eFileState!=etfsTRANSFER)));
		}

		nick       = "";
		hubname    = "";
		remotefile = "";
	}

	m = new QPopupMenu(this);

	DCMenuHandler::InsertMenu( m, emiSEARCH_FILE_CLONE, (size > 0) );
	DCMenuHandler::InsertMenu( m, emiSEPARATOR );
	DCMenuHandler::InsertMenu( m, emiREMOVE_TRANSFER_QUEUE, removetransfer );
	//DCMenuHandler::InsertMenu( m, emiREMOVE_TRANSFER_QUEUE_DISK, (removetransfer && FALSE) ); //(TransferItem.eState == etwsIDLE) );
	DCMenuHandler::InsertMenu( m, emiSEPARATOR );

	DCMenuHandler::InsertMenu( m, emiFILE_INFO, (localfile != "") && (size > 0) );

	id = m->exec(QCursor::pos());

	delete m;

        if ( id == emiREMOVE_TRANSFER_QUEUE )
        {
		if (g_pConfig->GetQueryOnFileDelete()) {
			// first we ask the user
			switch( QMessageBox::warning( this, tr("Remove Transfer"),
				tr("You are sure ?"),
				tr("Remove"),
				tr("Cancel"), 0, 0, 1 ) )
			{
				case 1: // The user clicked the Quit or pressed Escape
					return;
				default:
					break;
			}
		}

                if (item->depth() == 0)
                {
                        QListViewItem * tmpitem;
                        for(tmpitem=item->firstChild(); tmpitem; tmpitem=tmpitem->nextSibling())
                        {
                                nick       = tmpitem->text(0);
                                hubname    = tmpitem->text(1);
                                remotefile = tmpitem->text(2);
                                if ( DLM_QueueRemove(nick.ascii(),hubname.ascii(),remotefile.ascii()) == FALSE )
                                {
                                        // TODO: error handling
                                }
                        }
                }
                if ( DLM_QueueRemove(nick.ascii(),hubname.ascii(),remotefile.ascii()) == FALSE )
                {
                        // TODO: error handling
                }
        }
	else if ( id == emiFILE_INFO )
	{
		DCFileTransferInfo * ft;

		ft = new DCFileTransferInfo(localfile.latin1());
		ft->exec();
		delete ft;
	}
	else if ( id == emiSEARCH_FILE_CLONE )
	{
		if ( remotefile.isEmpty() )
			SearchFileClone(localfile, size);
		else
			SearchFileClone(remotefile, size);
	}
}

/** */
void DCTransferView::slotDoubleClickedTransferWaitList( QListViewItem * /*item*/ )
{
	QListViewItem * item;
	QListViewItem * item0;
	QString nick;
	QString hubname;
	QString hubhost;
        CUserFileInfo UserFileInfo;

	item = ListView_TRANSFERWAIT->currentItem();

	if (item->depth() == 0)
	{
		item0 = item;
	}
	else
	{
		item0 = item->parent();
	}

	nick    = item0->text(0);
	hubname = item0->text(1);
	hubhost = item0->text(2);

	if (item->depth() == 0)
	{
		if ( g_pConnectionManager->IsHubOnline(hubname.ascii(),hubhost.ascii()) == ehsNONE )
		{
			if ( DLM_QueueUpdateHub( nick.ascii(), hubname.ascii() ) == FALSE )
			{
				// TODO: error message ...
			}
			g_pConnectionManager->Connect( hubname.ascii(), hubhost.ascii() );
			return;
		}
	}

	if ( DLM_QueueGetFileInfo(nick.ascii(),hubname.ascii(),hubhost.ascii(),"",&UserFileInfo) == FALSE )
	{
		return;
	}

	if ( (UserFileInfo.eWaitState != etwsRUN) && (UserFileInfo.eWaitState != etwsWAIT) )
	{
		if ( DLM_TransferConnect( nick.ascii(), hubname.ascii() ) == FALSE )
		{
			// error message
			QMessageBox::critical( 0, tr("Try Connect"),
				tr("User and Hub not found in the queue !") + "\n\n" +
				tr("Nick:") + " '" +
				nick + "'\n" +
				tr("Hub:") + " '" + hubname + "'\n" );
		}
	}
}

/** */
void DCTransferView::slotRightButtonClickedUserSlotList( QListViewItem * item , const QPoint &, int )
{
	int id;
	QPopupMenu *m;

	if( item == 0 )
	{
		return;
	}

	m = new QPopupMenu(this);

	DCMenuHandler::InsertMenu( m, emiREMOVE );

        id = m->exec(QCursor::pos());

	delete m;

        if ( id == emiREMOVE )
        {
		g_pTransferView->DLM_AddUserSlot( item->text(0).ascii(), item->text(1).ascii(), 0 );
        }
}

/** */
void DCTransferView::slotRightButtonClickedLog( const QPoint& )
{
	int id;
	QPopupMenu *m;

	m = new QPopupMenu(this);

	DCMenuHandler::InsertMenu( m, emiCOPY, m_pTextEdit_LOG->hasSelectedText() );
	DCMenuHandler::InsertMenu( m, emiCLEAR, TRUE );
	DCMenuHandler::InsertMenu( m, emiSELECT_ALL, TRUE );

        id = m->exec(QCursor::pos());

	delete m;

	if ( id == emiCOPY )
	{
		m_pTextEdit_LOG->copy();
	}
	else if ( id == emiCLEAR )
	{
		m_pTextEdit_LOG->clear();
	}
	else if ( id == emiSELECT_ALL )
	{
		m_pTextEdit_LOG->selectAll();
	}
}
