/***************************************************************************
                          dceditserver.cpp  -  description
                             -------------------
    begin                : Fre Aug 29 2003
    copyright            : (C) 2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qgroupbox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qregexp.h>

#include <dclib/cconfig.h>

#include "dceditserver.h"

/** */
DCEditServer::DCEditServer(QWidget *parent, const char *name ) : DCDialogEditServer(parent,name)
{
	initDocument();
}

/** */
DCEditServer::~DCEditServer()
{
}

/** */
void DCEditServer::initDocument()
{
	GroupBox_PROFILE->hide();

	adjustSize();

	connect( PushButton_OK, SIGNAL(clicked()), this, SLOT(accept()) );
	connect( PushButton_CANCEL, SIGNAL(clicked()), this, SLOT(reject()) );
	connect( ToolButton_PROFILE, SIGNAL(clicked()), this, SLOT(slotToolButtonProfileClicked()) );

	connect( CheckBox_PROFILE, SIGNAL(toggled(bool)), this, SLOT(slotCheckBoxProfileToggled(bool)) );
}

/** */
void DCEditServer::Reset()
{
	LineEdit_PASSWORD->setText("");
	CheckBox_AUTOCONNECT->setChecked(FALSE);
	CheckBox_SSL->setChecked(FALSE);
	CheckBox_DESCRIPTIONTAG->setChecked(TRUE);
	
	slotCheckBoxProfileToggled(TRUE);
}

/** */
void DCEditServer::SetProfile( DCConfigHubProfile * profile )
{
	LineEdit_NICK->setText( profile->m_sNick.Data() );
	LineEdit_PASSWORD->setText( profile->m_sPassword.Data() );
	CheckBox_AUTOCONNECT->setChecked( profile->m_bAutoConnect );
	CheckBox_SSL->setChecked( profile->m_bSSL );
	CheckBox_DESCRIPTIONTAG->setChecked( profile->m_bTag );
	LineEdit_EMAIL->setText( profile->m_sEMail.Data() );
	CheckBox_EMAIL->setChecked( profile->m_bEMail );
	LineEdit_PROF_DESCRIPTION->setText( profile->m_sComment.Data() );
	CheckBox_DESCRIPTION->setChecked( profile->m_bComment );
	
	slotCheckBoxProfileToggled(TRUE);
}

/** */
void DCEditServer::GetProfile( DCConfigHubProfile * profile )
{
	profile->m_sName        = LineEdit_NAME->text();
	profile->m_sNick        = LineEdit_NICK->text().replace( QRegExp(" "), "\xa0").ascii();
	profile->m_sPassword    = LineEdit_PASSWORD->text().ascii();
	profile->m_bAutoConnect = CheckBox_AUTOCONNECT->isChecked();
	profile->m_bSSL         = CheckBox_SSL->isChecked();
	profile->m_bTag         = CheckBox_DESCRIPTIONTAG->isChecked();
	profile->m_bComment     = CheckBox_DESCRIPTION->isChecked();
	profile->m_sComment     = LineEdit_PROF_DESCRIPTION->text();
	profile->m_bEMail       = CheckBox_EMAIL->isChecked();
	profile->m_sEMail       = LineEdit_EMAIL->text();
}

/** */
void DCEditServer::slotToolButtonProfileClicked()
{
	int w = width();
	
	if ( GroupBox_PROFILE->isVisible() )
	{
		GroupBox_PROFILE->hide();
	}
	else
	{
		GroupBox_PROFILE->show();
	}

	adjustSize();
	
	resize( w, height() );
}

/** */
void DCEditServer::slotCheckBoxProfileToggled( bool on )
{
	CheckBox_PROFILE->setChecked(on);
	
	if ( !on )
	{
		// hide profile window if disabled
		if ( GroupBox_PROFILE->isVisible() )
		{
			slotToolButtonProfileClicked();
		}
	}

	ToolButton_PROFILE->setEnabled(on);
}
