/***************************************************************************
                          dcconfig.h  -  description
                             -------------------
    begin                : Fri Mar 1 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCCONFIG_H
#define DCCONFIG_H

/**
  *@author Mathias Kster
  */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qpixmap.h>
#include <qvaluevector.h>
#include <qlistview.h>
#include <qheader.h>
#include <qptrlist.h>
#include <qimage.h>
#include <qobject.h>

#include <dclib/cconfig.h>

#include <libxml/xmlversion.h>
#if LIBXML_VERSION > 20406
#include <libxml/globals.h>
#endif
#include <libxml/parser.h>
#include <libxml/tree.h>

/** */
typedef enum eUserIconType {
	euitOPERATOR,
	euitUSER,
	euitUSER_AWAY
} eUserIconType;

/** */
typedef enum eUserSound {
	eusCONNECT,
	eusDISCONNECT,
	eusSEND,
	eusRECEIVE,
	eusFIRSTRECEIVE
} eUserSound;

/** */
typedef enum eChatTextCodec {
	ectcINPUT=0,
	ectcOUTPUT
};

/** */
typedef enum eTimeStamp {
	etsPRIVATECHAT,
	etsHUBCHAT
} eTimeStamp;

/** */
typedef enum eTransferViewOptions {
	etvoCHUNKPERCENT,
	etvoFILEPERCENT,
	etvoCHUNKSIZE,
	etvoFILESIZE,
	etvoDOWNLOADRATESINGLE,
	etvoELAPSEDTIMESINGLE,
	etvoDOWNLOADRATEMULTI,
	etvoELAPSEDTIMEMULTI
} eTransferViewOptions;

/** */
typedef enum eLogChatOptions {
	elcoENABLELOGGING,
	elcoAPPENDDATE,
	elcoAPPENDHUBNAME,
	elcoAPPENDHUBHOST,
	elcoDISABLEPUBLICCHAT,
	elcoENABLENICKNAMEFILTER,
	elcoNICKNAMEFILTER_ENABLELOGGING
} eLogChatOptions;

/** */
typedef enum eChatColor {
	eccCHATTIMESTAMP=0,
	eccCHATLOCALNICK,
	eccCHATLOCALTEXT,
	eccCHATREMOTENICK,
	eccCHATREMOTETEXT,
	eccCHATSTATUSNICK,
	eccCHATSTATUSTEXT,
	eccPUBLICCHATTIMESTAMP,
	eccPUBLICCHATLOCALNICK,
	eccPUBLICCHATLOCALTEXT,
	eccPUBLICCHATREMOTENICK,
	eccPUBLICCHATREMOTETEXT,
	eccPUBLICCHATSTATUSNICK,
	eccPUBLICCHATSTATUSTEXT,
	eccPUBLICPRIVATECHATNICK,
	eccPUBLICPRIVATECHATTEXT,
	eccCHATSAY,
	eccPUBLICCHATMENICK,
} eChatColor;

typedef enum eClientColumn {
	eclcCOMMENT=0,
	eclcTAG,
	eclcEMAIL,
	eclcSPEED,
	eclcSHARE,
	eclcIP,
	eclcLOCKPK,
	eclcSUPPORTS
} eClientColumn;

class CString;
class CThread;

/* Default application font. Needed from main.cpp too */
#define DEFAULT_APP_FONT	"Helvetica,12,-1,5,50,0,0,0,0,0"

class QProcess;
class QPixmap;
/** */
typedef QMap<QString, QString> StringMap;
/** */
typedef QMap<QString, StringMap*> SettingMap;

/** */
class DC_EmoticonObject : public CObject {
public:
	/** construtor */
	DC_EmoticonObject() {};
	/** destructor */
	virtual ~DC_EmoticonObject() {};

	/** */
	CString m_Text;
	/** */
	int left,top,right,bottom;
	/** */
	int m_nID;
};

/** */
class DC_HubFilterObject : public CObject {
public:
	/** construtor */
	DC_HubFilterObject() {
		m_nUser        = 0;
		m_bName        = FALSE;
		m_bServer      = FALSE;
		m_bDescription = FALSE;
	};
	/** destructor */
	virtual ~DC_HubFilterObject() {};

	/** */
	CString m_sFilterName;
	/** */
	CString m_sContains;
	/** */
	int m_nUser;
	/** */
	bool m_bName;
	/** */
	bool m_bServer;
	/** */
	bool m_bDescription;
};

class DCConfig : public CConfig {
public:
	/** construtor */
	DCConfig( CString configpath = "" );
	/** destructor */
	virtual ~DCConfig();

	/** */
	int Load();
	/** */
	int Save();

	/** */
	int LoadDCGui();
	/** */
	int SaveDCGui();
	/** */
	void ParseDCGuiConfig( xmlNodePtr node );

	/** */
	int LoadDCHubFilter( CStringList * list );
	/** */
	int SaveDCHubFilter( CStringList * list );

	/** */
	int LoadDCFriendList( CStringList * list );
	/** */
	int SaveDCFriendList( CStringList * list );

	/** */
	bool GetOpenPrivateChatWindow() const;
	/** */
	void SetOpenPrivateChatWindow( bool b );
	/** */
	long GetChatMaxParagraph() const;
	/** */
	void SetChatMaxParagraph( long i );
	/** */
	bool GetChatShowJoinsAndParts() const;
	/** */
	void SetChatShowJoinsAndParts( bool b );

	/** */
	eUnit GetUnit() const;
	/** */
	void SetUnit( eUnit unit );
	/** */
	bool GetTransferViewOptions( eTransferViewOptions e ) const;
	/** */
	void SetTransferViewOptions( eTransferViewOptions e, bool b );
	/** */
	CString GetTheme() const;
	/** */
	void SetTheme( CString theme );
	/** */
	CString GetSendChat() const;
	/** */
	void SetSendChat( CString sendchat );
	/** */
	CString GetLanguageFile() const;
	/** */
	void SetLanguageFile( CString languagefile );
        /** */
	bool GetToolBar() const;
	/** */
	void SetToolBar( bool b );
	/** */
	bool GetStatusBar() const;
	/** */
	void SetStatusBar( bool b );
	/** */
	bool GetUserListRightAlignment() const;
	/** */
	void SetUserListRightAlignment( bool b );

	/** */
	QPixmap * GetUserIcon( bool op, eClientMode clientmode, eUserAwayMode awaymode, eUserSpeed speed, eUserClientVersion version );
	/** */
	void PlaySound( eUserSound usersound );
	/** */
	void PlaySound( CString file );

	/** */
	void SetAppFont( CString font );
	/** */
	CString GetAppFont() const;

	/** */
	bool GetMap( CString name, StringMap *& map );

	/** */
	void SetGeometry( CString name, int x, int y, int width, int height );
	/** */
	void GetGeometry( CString name, int &x, int &y, int &width, int &height );

	/** */
	void SetAppGeometry( int width, int height );
	/** */
	void GetAppGeometry( int &width, int &height );
	/** */
	void SetTransferViewGeometry( int width, int height );
	/** */
	void GetTransferViewGeometry( int &width, int &height );
	/** */
	void SetTransferViewDocked( bool b );
	/** */
	bool GetTransferViewDocked() const;

	/** */
	bool GetSoundDisabled() const;
	/** */
	void SetSoundDisabled( bool disabled );
	/** */
	bool GetSoundDisabledAway() const;
	/** */
	void SetSoundDisabledAway( bool disabled );
	/** */
	bool GetExternalSoundPlayer() const;
	/** */
	void SetExternalSoundPlayer( bool externalsoundplayer );
	/** */
	CString GetExternalPlayer() const;
	/** */
	void SetExternalPlayer( CString externalplayer );
	/** */
	CString GetSoundFile( eUserSound usersound );
	/** */
	void SetSoundFile( eUserSound usersound, CString soundfile );
	/** */
	bool GetSoundEnabled( eUserSound usersound );
	/** */
	void SetSoundEnabled( eUserSound usersound, bool enabled );

	/** */
	void SetTimeStamp( eTimeStamp timestamp, bool enabled );
	/** */
	bool GetTimeStamp( eTimeStamp timestamp );

	/** */
	void SetLogChatOption( eLogChatOptions elco, bool enabled );
	/** */
	bool GetLogChatOption( eLogChatOptions elco );
	/** */
	void SetLogChatNickNameFilter( CList<CString> * list );
	/** */
	void GetLogChatNickNameFilter( CList<CString> * list );
	/** */
	bool CheckLogChatNickNameFilter( CString nick );

	/** */
	bool GetShowStatusMessage() const;
	/** */
	void SetShowStatusMessage( bool disabled );
	/** */
	bool GetShowTransferWin() const;
	/** */
	void SetShowTransferWin( bool disabled );

	/** */
	bool GetSendHidePrivateChatToPublicChat() const;
	/** */
	void SetSendHidePrivateChatToPublicChat( bool b );

	/** */
	bool GetEnableEmoticons() const;
	/** */
	void SetEnableEmoticons( bool b );

	/** */
	bool GetAutoAwayMode() const;
	/** */
	void SetAutoAwayMode( bool b );
	/** */
	int GetAutoAwayTime() const;
	/** */
	void SetAutoAwayTime( int n );

	/** */
	int GetChatMessageMaxLines() const;
	/** */
	void SetChatMessageMaxLines( int i );
	/** */
	CString GetChatTextCodec( eChatTextCodec e );
	/** */
	void SetChatTextCodec( eChatTextCodec e, CString s );

	/** */
	int GetFloodCount() const;
	/** */
	void SetFloodCount( int i );
	/** */
	bool GetFloodOpKick() const;
	/** */
	void SetFloodOpKick( bool b );

	/** */
	bool GetThemeSupport() const;
	/** */
	void SetThemeSupport( bool b );
	/** */
	CString GetBackgroundPixmap() const;
	/** */
	void SetBackgroundPixmap( CString s );
	/** */
	CString GetBrowser() const;
	/** */
	void SetBrowser( CString s );

	/** */
	unsigned int GetDefaultDownloadMode() const;
	/** 0:ask, 1:single, 2:multi */
	void SetDefaultDownloadMode( unsigned int n );

	/** */
	bool GetQueryOnExit() const;
	/** */
	void SetQueryOnExit( bool b );
	/** */
	bool GetQueryOnFileDelete() const;
	/** */
	void SetQueryOnFileDelete( bool b );

	/** */
	bool GetShowChatSendButton() const;
	/** */
	void SetShowChatSendButton( bool b );
	/** */
	bool GetShowChatInTab() const;
	/** */
	void SetShowChatInTab( bool b );
	/** */
	CString GetChatColor( eChatColor type ) const;
	/** */
	void SetChatColor( eChatColor type, CString s );
	/** */
	bool GetOpenClientWindowsMinimized() const;
	/** */
	void SetOpenClientWindowsMinimized( bool b );

	/** */
	bool GetClientColumn( eClientColumn e );
	/** */
	void SetClientColumn( eClientColumn e, bool b );

	/** */
	bool InitMimeSourceFactory();
	/** */
	CList<DC_EmoticonObject> * EmoticonList();
	/** */
	QImage & GetEmoticonImage();

	/** */
	CString GetUserPhotoFileName() const;
	/** */
	void SetUserPhotoFileName( CString s );

private:
	/** */
	SettingMap m_guiSettingMap;

	/** */
	bool bOpenPrivateChatWindow;
	/** */
	long m_nChatMaxParagraph;
	/** */
	bool bShowTransferWin;
	/** */
	bool bToolBar;
	/** */
	bool bStatusBar;
	/** */
	bool bUserListRightAlignment;
	/** */
	eUnit m_eUnit;
	/** */
	CString sTheme;
	/** */
	CString sSendChat;
	/** */
	bool bThemeSupport;
	/** */
	CString sLanguageFile;
	/** Application font */
	CString sAppFont;
	/** Application height */
	int iAppHeight;
	/** Application Width */
	int iAppWidth;
	/** TransferView height */
	int iTransferViewHeight;
	/** TransferView Width */
	int iTransferViewWidth;
	/** TransferView Docked */
	int bTransferViewDocked;
	/** */
	bool bSoundDisabled;
	/** */
	bool bSoundDisabledAway;
	/** */
	bool bSoundEnabledConnect;
	/** */
	bool bSoundEnabledDisconnect;
	/** */
	bool bSoundEnabledSend;
	/** */
	bool bSoundEnabledReceive;
	/** */
	bool bSoundEnabledFirstReceive;
	/** */
	bool bExternalSoundPlayer;
	/** */
	CString sExternalPlayer;
	/** connect sound file */
	CString sSoundFileConnect;
	/** disconnect sound file */
	CString sSoundFileDisconnect;
	/** send sound file */
	CString sSoundFileSend;
	/** receive sound file */
	CString sSoundFileReceive;
	/** first receive sound file */
	CString sSoundFileFirstReceive;

	/** */
	bool bEnableEmoticons;
	/** */
	bool bTimeStampPrivateChat;
	/** */
	bool bTimeStampHubChat;
	/** */
	bool bShowStatusMessage;
	/** */
	bool bSendHidePrivateChatToPublicChat;
	/** */
	bool bTVChunkPercent;
	/** */	
	bool bTVFilePercent;
	/** */	
	bool bTVChunkSize;
	/** */
	bool bTVFileSize;
	/** */	
	bool bTVDownloadRateSingle;
	/** */	
	bool bTVElapsedTimeSingle;
	/** */	
	bool bTVDownloadRateMulti;
	/** */	
	bool bTVElapsedTimeMulti;
		
	/** */
	bool m_bLogChatOption_1;
	/** */
	bool m_bLogChatOption_2;
	/** */
	bool m_bLogChatOption_3;
	/** */
	bool m_bLogChatOption_4;
	/** */
	bool m_bLogChatOption_5;
	/** */
	bool m_bLogChatOption_6;
	/** */
	bool m_bLogChatOption_7;
	/** */
	CList<CString> m_pLogChatNickNameFilter;

	/** */
	int iChatMessageMaxLines;
	/** */
	QMimeSourceFactory * m_pMimeSourceFactory;
	
	/** */
	int iFloodCount;
	/** */
	bool m_bFloodOpKick;

	/** */
	CList<DC_EmoticonObject> * m_EmoticonSettingList;
	/** */
	QImage m_EmoticonImage;

	/** */
	QProcess * pProcess;

	/** */
	QPixmap m_UserIconCache;
	/** */
	int m_nUICX,m_nUICY;
	/** */
	QImage m_UserIcons;

	/** 0:ask, 1:single, 2:multi */
	int iDefaultDownloadMode;
	/** */
	bool m_bAutoAwayMode;
	/** */
	int m_nAutoAwayTime;

	/** */
	bool bQueryOnExit;
	/** */
	bool bQueryOnFileDelete;
	/** */
	bool bShowChatSendButton;
	/** */
	CString sBackgroundPixmap;
	/** */
	CString sBrowser;
	/** */
	bool bShowChatInTab;
	/** */
	CString m_sChatColor_1;
	/** */
	CString m_sChatColor_2;
	/** */
	CString m_sChatColor_3;
	/** */
	CString m_sChatColor_4;
	/** */
	CString m_sChatColor_5;
	/** */
	CString m_sChatColor_6;
	/** */
	CString m_sChatColor_7;
	/** */
	CString m_sChatColor_8;
	/** */
	CString m_sChatColor_9;
	/** */
	CString m_sChatColor_10;
	/** */
	CString m_sChatColor_11;
	/** */
	CString m_sChatColor_12;
	/** */
	CString m_sChatColor_13;
	/** */
	CString m_sChatColor_14;
	/** */
	CString m_sChatColor_15;
	/** */
	CString m_sChatColor_16;
	/** */
	CString m_sChatColor_17;
	/** */
	CString m_sChatColor_18;
	/** */
	bool bOpenClientWindowsMinimized;
	/** */
	bool m_bChatShowJoinsAndParts;
	/** */
	CString m_sChatInputCodec;
	/** */
	CString m_sChatOutputCodec;

	/** */
	bool m_bClientColumnComment;
	/** */
	bool m_bClientColumnTag;
	/** */
	bool m_bClientColumnEMail;
	/** */
	bool m_bClientColumnSpeed;
	/** */
	bool m_bClientColumnShare;
	/** */
	bool m_bClientColumnIP;
	/** */
	bool m_bClientColumnLOCKPK;
	/** */
	bool m_bClientColumnSUPPORTS;

	/** */
	CString m_sUserPhotoFileName;
};

/** global config */
extern DCConfig * g_pConfig;

/** inline functions */

/** */
inline bool DCConfig::GetOpenPrivateChatWindow() const
{ return bOpenPrivateChatWindow; }
/** */
inline void DCConfig::SetOpenPrivateChatWindow( bool b )
{ bOpenPrivateChatWindow = b; }
/** */
inline bool DCConfig::GetToolBar() const
{ return bToolBar; }
/** */
inline void DCConfig::SetToolBar( bool b )
{ bToolBar = b; }
/** */
inline bool DCConfig::GetStatusBar() const
{ return bStatusBar; }
/** */
inline void DCConfig::SetStatusBar( bool b )
{ bStatusBar = b; }
/** */
inline bool DCConfig::GetUserListRightAlignment() const
{ return bUserListRightAlignment; }
/** */
inline void DCConfig::SetUserListRightAlignment( bool b )
{ bUserListRightAlignment = b; }
/** */
inline eUnit DCConfig::GetUnit() const
{ return m_eUnit; }
/** */
inline void DCConfig::SetUnit( eUnit unit )
{ m_eUnit = unit; }
/** */
inline CString DCConfig::GetTheme() const
{ return sTheme; }
/** */
inline void DCConfig::SetTheme( CString theme )
{ sTheme = theme; }

/** */
inline CString DCConfig::GetSendChat() const
{ return sSendChat; }
/** */
inline void DCConfig::SetSendChat( CString sendchat )
{ sSendChat = sendchat; }

/** */
inline CString DCConfig::GetLanguageFile() const
{ return sLanguageFile; }
/** */
inline void DCConfig::SetLanguageFile( CString languagefile )
{ sLanguageFile = languagefile; }

inline CString DCConfig::GetAppFont() const
{ return sAppFont; }
inline void DCConfig::SetAppFont(CString font)
{ sAppFont = font; }
/** */
inline void DCConfig::SetAppGeometry( int width, int height )
{ iAppWidth=width;iAppHeight=height; }
/** */
inline void DCConfig::GetAppGeometry( int &width, int &height )
{ width=iAppWidth;height=iAppHeight; }
/** */
inline void DCConfig::SetTransferViewGeometry( int width, int height )
{ iTransferViewWidth=width;iTransferViewHeight=height; }
/** */
inline void DCConfig::GetTransferViewGeometry( int &width, int &height )
{ width=iTransferViewWidth;height=iTransferViewHeight; }
/** */
inline void DCConfig::SetTransferViewDocked( bool b )
{ bTransferViewDocked = b; }
/** */
inline bool DCConfig::GetTransferViewDocked() const
{ return bTransferViewDocked; }
/** */
inline bool DCConfig::GetSoundDisabled() const
{ return bSoundDisabled; }
/** */
inline void DCConfig::SetSoundDisabled( bool disabled )
{ bSoundDisabled = disabled; }
/** */
inline bool DCConfig::GetSoundDisabledAway() const
{ return bSoundDisabledAway; }
/** */
inline void DCConfig::SetSoundDisabledAway( bool disabled )
{ bSoundDisabledAway = disabled; }
/** */
inline bool DCConfig::GetExternalSoundPlayer() const
{ return bExternalSoundPlayer; }
/** */
inline void DCConfig::SetExternalSoundPlayer( bool externalsoundplayer )
{ bExternalSoundPlayer = externalsoundplayer; }
/** */
inline CString DCConfig::GetExternalPlayer() const
{ return sExternalPlayer; }
/** */
inline void DCConfig::SetExternalPlayer( CString externalplayer )
{ sExternalPlayer = externalplayer; }
/** */
inline bool DCConfig::GetShowStatusMessage() const
{ return bShowStatusMessage; }
/** */
inline void DCConfig::SetShowStatusMessage( bool b )
{ bShowStatusMessage = b; }
/** */
inline bool DCConfig::GetShowTransferWin() const
{ return bShowTransferWin; }
/** */
inline void DCConfig::SetShowTransferWin( bool b )
{ bShowTransferWin = b; }
/** */
inline bool DCConfig::GetThemeSupport() const
{ return bThemeSupport; }
/** */
inline void DCConfig::SetThemeSupport( bool b )
{ bThemeSupport = b; }
/** */
inline bool DCConfig::GetSendHidePrivateChatToPublicChat() const
{ return bSendHidePrivateChatToPublicChat; }
/** */
inline void DCConfig::SetSendHidePrivateChatToPublicChat( bool b )
{ bSendHidePrivateChatToPublicChat = b; }
/** */
inline int DCConfig::GetChatMessageMaxLines() const
{ return iChatMessageMaxLines; }
/** */
inline void DCConfig::SetChatMessageMaxLines( int i )
{ iChatMessageMaxLines = i; }
/** */
inline void DCConfig::SetFloodCount( int i )
{ iFloodCount = i; }
/** */
inline int DCConfig::GetFloodCount() const
{ return iFloodCount; }
/** */
inline void DCConfig::SetFloodOpKick( bool b )
{ m_bFloodOpKick = b; }
/** */
inline bool DCConfig::GetFloodOpKick() const
{ return m_bFloodOpKick; }
/** */
inline unsigned int DCConfig::GetDefaultDownloadMode() const
{ return iDefaultDownloadMode; }
/** */
inline void DCConfig::SetDefaultDownloadMode( unsigned int n )
{ iDefaultDownloadMode = n; }
/** */
inline bool DCConfig::GetEnableEmoticons() const
{ return bEnableEmoticons; }
/** */
inline void DCConfig::SetEnableEmoticons( bool b )
{ bEnableEmoticons = b; }
/** */
inline bool DCConfig::GetQueryOnExit() const
{ return bQueryOnExit; }
/** */
inline void DCConfig::SetQueryOnExit( bool b )
{ bQueryOnExit = b; }
/** */
inline bool DCConfig::GetQueryOnFileDelete() const
{ return bQueryOnFileDelete; }
/** */
inline void DCConfig::SetQueryOnFileDelete( bool b )
{ bQueryOnFileDelete = b; }
/** */
inline bool DCConfig::GetShowChatSendButton() const
{ return bShowChatSendButton; }
/** */
inline void DCConfig::SetShowChatSendButton( bool b )
{ bShowChatSendButton = b; }
/** */
inline CString DCConfig::GetBackgroundPixmap() const
{ return sBackgroundPixmap; }
/** */
inline void DCConfig::SetBackgroundPixmap( CString s )
{ sBackgroundPixmap = s; }
/** */
inline CString DCConfig::GetBrowser() const
{ return sBrowser; }
/** */
inline void DCConfig::SetBrowser( CString s )
{ sBrowser = s; }
/** */
inline bool DCConfig::GetShowChatInTab() const
{ return bShowChatInTab; }
/** */
inline void DCConfig::SetShowChatInTab( bool b )
{ bShowChatInTab = b; }
/** */
inline long DCConfig::GetChatMaxParagraph() const
{ return m_nChatMaxParagraph; }
/** */
inline void DCConfig::SetChatMaxParagraph( long i )
{ m_nChatMaxParagraph = i; }
/** */
inline bool DCConfig::GetOpenClientWindowsMinimized() const
{ return bOpenClientWindowsMinimized; }
/** */
inline void DCConfig::SetOpenClientWindowsMinimized( bool b )
{ bOpenClientWindowsMinimized = b; }
/** */
inline bool DCConfig::GetAutoAwayMode() const
{ return m_bAutoAwayMode; }
/** */
inline void DCConfig::SetAutoAwayMode( bool b )
{ m_bAutoAwayMode = b; }
/** */
inline int DCConfig::GetAutoAwayTime() const
{ return m_nAutoAwayTime; }
/** */
inline void DCConfig::SetAutoAwayTime( int n )
{ m_nAutoAwayTime = n; }
/** */
inline bool DCConfig::GetChatShowJoinsAndParts() const
{ return m_bChatShowJoinsAndParts; }
/** */
inline void DCConfig::SetChatShowJoinsAndParts( bool b )
{ m_bChatShowJoinsAndParts = b; }
/** */
inline CString DCConfig::GetUserPhotoFileName() const
{ return m_sUserPhotoFileName; }
/** */
inline void DCConfig::SetUserPhotoFileName( CString s )
{ m_sUserPhotoFileName = s; }

#endif
